/* Copyright (C) 2019 Moxa Inc. All rights reserved. */
/* SPDX-License-Identifier: Apache-2.0 */
/*!
    \file mx_node_node.h
    \copyright Moxa Inc.
    \brief <b> \a MX_NODE_NODE \a 's related APIs.</b>
    \date 2019-06-11
    \author Rich Liao
    \version V1.0
*/

#ifndef __MX_NODE_NODE__
#define __MX_NODE_NODE__

#include <stdlib.h>
#include <sys/time.h>
#include "mx_node_node_def.h"

/*!
    \addtogroup Library
    @{
*/

/*!
    \addtogroup MX_Node_SDK
    @{
*/

/*!
    \addtogroup Node_Operator
    @{
*/

/*!
    \brief Handle of a node operator.
*/
typedef size_t MX_NODE_NODE_OPERATOR_HANDLE;

/*!
    \brief Handle of a node.
*/
typedef size_t MX_NODE_NODE_HANDLE;

/*!
    \brief Add a node to OPC UA server.
    \param[in] operator_handle: This node operator handle is provided from mx_node_operator_initialize() of interface basic.
    \param[in] node: The node which is added.
    \param[out] node_handle: The node's handle, it is used to communicate with server.
    \return Add success or not.
*/
MX_NODE_RESULT mx_node_add_node(MX_NODE_NODE_OPERATOR_HANDLE operator_handle, MX_NODE_NODE* node, MX_NODE_NODE_HANDLE* node_handle);

/*!
    \brief Set a node's parent.
    \param[in] node_handle: The node which is set parent.
    \param[in] parent_node_handle: The parent node's handle.
    \return Set parent success or not.
*/
MX_NODE_RESULT mx_node_set_parent_node(MX_NODE_NODE_HANDLE node_handle, MX_NODE_NODE_HANDLE parent_node_handle);

/*!
    \brief Update a node's data and timestamp.
    \param[in] node_handle: The handle of node which is updated.
    \param[in] value: The node's updated date.
    \param[in] timestamp: The node's source timestamp.
    \return Update success or not.
*/
MX_NODE_RESULT mx_node_update_node(MX_NODE_NODE_HANDLE node_handle, MX_NODE_VARIANT* value, struct timeval* timestamp);

//! @}

//! @}

//! @}

#endif