/* Copyright (C) 2019 Moxa Inc. All rights reserved. */
/* SPDX-License-Identifier: Apache-2.0 */
/*!
    \file mx_node_interface_data_access.h
    \copyright Moxa Inc.
    \brief <b> Interface \a Data \a \a Access \a contains node operations of data access.</b>
    \date 2019-06-11
    \author Rich Liao
    \version V1.0
    \note Data accessing's node operations include reading and writing a node.
*/

#ifndef __MX_NODE_INTERFACE_DATA_ACCESS__
#define __MX_NODE_INTERFACE_DATA_ACCESS__

#include <sys/time.h>
#include "mx_node_node_def.h"

/*!
    \addtogroup Library
    @{
*/

/*!
    \addtogroup MX_Node_SDK
    @{
*/

/*!
    \addtogroup Interface
    @{
*/

/*!
    \addtogroup Data_Access
    @{
*/

/*!
    \brief Read a node's data and timestamp.
    \param[in]  node_handle: The handle of node, which is read.
    \param[out] node_value: The variant is set to node's data.
    \param[out] node_timestamp: The timestamp is set to node's source timestamp.
    \return Read success or not.
*/
MX_NODE_RESULT mx_node_operator_read_node(MX_NODE_NODE_HANDLE node_handle, MX_NODE_VARIANT* node_value, struct timeval* node_timestamp);

/*!
    \brief Write data by handle index.
    \param[in] node_handle: The handle of node, which is written.
    \param[in] node_value: The written data.
    \return Write success or not.
*/
MX_NODE_RESULT mx_node_operator_write_node(MX_NODE_NODE_HANDLE node_handle, const MX_NODE_VARIANT* node_value);

//! @}

//! @}

//! @}

//! @}

#endif