/* Copyright (C) 2019 Moxa Inc. All rights reserved. */
/* SPDX-License-Identifier: Apache-2.0 */
/*!
    \file mx_node_interface_basic.h
    \copyright Moxa Inc.
    \brief <b> Interface \a Basic \a is supported mandatorily, it contains basic operations.</b>
    \date 2019-06-11
    \author Rich Liao
    \version V1.0
    \note These basic operations are not all doing node operation, some prodive node operator's information or run start and stop processes.
*/

#ifndef __MX_NODE_INTERFACE_BASIC__
#define __MX_NODE_INTERFACE_BASIC__

#include "mx_node_node.h"

/*!
    \addtogroup Library
    @{
*/

/*!
    \addtogroup MX_Node_SDK
    @{
*/

/*!
    \addtogroup Interface
    @{
*/

/*!
    \addtogroup Basic
    @{
*/

/*!
    \brief Interface basic's flag.
    \note Flag is used to represent supported interface in mx_node_operator_get_supported_interfaces().
*/
#define INTERFACE_MX_NODE_BASIC       (1ll << 0)

/*!
    \brief Interface data access's flag.
    \note Flag is used to represent supported interface in mx_node_operator_get_supported_interfaces().
*/
#define INTERFACE_MX_NODE_DATA_ACCESS (1ll << 1)

/*!
    \brief Get node operator's version.
    \return A string with node operator's version.
*/
const char* mx_node_operator_get_version();

/*!
    \brief Get supported interfaces.
    \return Flags which represent interfaces are supported.
*/
long long mx_node_operator_get_supported_interfaces();

/*!
    \brief Do node operator's initialize, like create nodes.
    \return Initialize success or not.
*/
MX_NODE_RESULT mx_node_operator_initialize(MX_NODE_NODE_OPERATOR_HANDLE operator_handle);

/*!
    \brief Do node operator's uninitialize.
*/
void mx_node_operator_uninitialize();

/*!
    \brief A notify to inform node operator start with non-blocking.
    \note OPC UA server is ready, the node operator can start doing its jobs.
*/
void mx_node_operator_start();

/*!
    \brief A notify to inform node operator stopping.
    \note This node operator will be closed, you need to stop the thread in mx_node_operator_start() if you keep it.
*/
void mx_node_operator_stop();

//! @}

//! @}

//! @}

//! @}

#endif