#ifndef __DATA_SET__
#define __DATA_SET__

#include <sys/time.h>
#include <stdio.h>
#include <mx_node_sdk/mx_node_interface_basic.h>
#include <mx_node_sdk/mx_node_interface_data_access.h>

#include "cJSON.h"
#define MX_PARSE_CONFIG_ERR -1
#define MX_IO_CONTROL_OK 0
#define MX_IO_CONTROL_ERR -1

typedef struct _io_node
{
    int ch; //uint8_t
    char name[64];
    int var_type;
    int func_type;
    int access;
    char description[64];
    MX_NODE_NODE_HANDLE node_handle;
    MX_NODE_VARIANT data;
    struct timeval timestamp;
}NODE;

typedef enum {
    OPC_DI_MODE = 10,
    OPC_DI_STATUS,
    OPC_DI_COUNTERSTATUS,
    OPC_DI_COUNTERVALUE,
    OPC_DO_MODE = 20,
    OPC_DO_STATUS,
    OPC_DO_PULSESTATUS,
    OPC_DO_PULSECOUNT,
    OPC_AI_MODE = 30,
    OPC_AI_STATUS,
    OPC_AI_RAWVALUE,
    OPC_AI_MINIMUMRAWVALUE,
    OPC_AI_MAXIMUMRAWVALUE,
    OPC_AI_SCALEDVALUE,
    OPC_RELAY_VALUE = 40
}FUNC_TYPE;

int parse_json_file(const char *filename);/* Read a file, parse, render back, etc. */
int cJSON_to_struct_array(char *text);
int io_control_read(int slot, int index, MX_NODE_VARIANT* node_value);
int io_control_write(int slot, int index, const MX_NODE_VARIANT* node_value);

struct timeval Now()
{
    struct timeval now;
    gettimeofday(&now, NULL);
    return now;
}
#endif
