# this one is important
set(CMAKE_SYSTEM_NAME Linux)

# set this to the folder containing the raspbian toolchain
set(BASE_PATH /usr/local/bin/gcc-linaro-5.1-native_arm-linux-gnueabihf)

# specify the cross compiler
set(CMAKE_C_COMPILER ${BASE_PATH}/bin/arm-linaro-linux-gnueabihf-gcc)
set(CMAKE_CXX_COMPILER ${BASE_PATH}/bin/arm-linaro-linux-gnueabihf-g++)

set(CMAKE_AR "${BASE_PATH}/bin/arm-linaro-linux-gnueabihf-ar" CACHE PATH "ARM Linux ar Program")

# where is the target environment (compiler and openssl)
set(CMAKE_FIND_ROOT_PATH ${BASE_PATH}/arm-cortex_a8-linux-gnueabihf)

# This is the mx_node_sdk include directory
set(MX_NODE_SDK_INC_DIR /usr/include)

# search for programs in the build host directories
set(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
# for libraries and headers in the target directories
set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
set(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)

unset(CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES)
unset(CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES)