# this one is important
set(CMAKE_SYSTEM_NAME Linux)

# set this to the folder containing the raspbian toolchain
set(BASE_PATH /usr/local/arm-linux-gnueabihf)

# specify the cross compiler
set(CMAKE_C_COMPILER ${BASE_PATH}/bin/arm-linux-gnueabihf-gcc)
set(CMAKE_CXX_COMPILER ${BASE_PATH}/bin/arm-linux-gnueabihf-g++)

set(CMAKE_AR "${BASE_PATH}/bin/arm-linux-gnueabihf-ar" CACHE PATH "ARM Linux ar Program")

# where is the target environment (compiler and openssl)
set(CMAKE_FIND_ROOT_PATH ${BASE_PATH}/arm-linux-gnueabihf)

# This is the mx_node_sdk include directory
set(MX_NODE_SDK_INC_DIR ${BASE_PATH}/arm-linux-gnueabihf/libc/usr/include)

# search for programs in the build host directories
set(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
# for libraries and headers in the target directories
set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
set(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)
