'''
    Copyright (C) 2019 Moxa Inc. All rights reserved.
    SPDX-License-Identifier: Apache-2.0

    Miscellaneous Python Sample Application

    Date          Author            Comment
    2019-02-11    William Chang     Created it.
'''

##
# @file misc.py
# @copyright 2019 Moxa Inc. All rights reserved.
# @date 2019-02-11
# @author William Chang
# @version V1.0
# @brief <b>Miscellaneous Sample</b>
# @details <b>Library:</b><br>
# @link Misc Misc APIs @endlink
# @include misc.py

from ioThinx_4530 import ioThinx_4530_API
import argparse

LED_CHANNEL_U1 = 1
LED_CHANNEL_U2 = 2
LED_STATE_DARK = 0
LED_STATE_GREEN = 1
LED_STATE_RED = 2


def main():
    parser = argparse.ArgumentParser(description="Miscellaneous sample program.")
    parser.add_argument("-s", "--slot", dest="module_slot", type=int, default=1)
    args = parser.parse_args()

    # initialize ioThinx I/O
    misc_slot = 0
    module_slot = args.module_slot
    device = ioThinx_4530_API.ioThinx_4530_API()

    # module infomation
    module_count = device.ioThinx_Misc_GetModuleCount()
    print("Module count = {}".format(module_count))
    print("Module slot = {}".format(module_slot))

    module_info = device.ioThinx_Misc_GetModuleInfo(module_slot)
    print("Slot {} Module Information:".format(module_slot))
    print("Model Name: {}".format(module_info["model_name"]))
    print("Serial Number: {}".format(module_info["serial_number"]))

    # locating
    device.ioThinx_Misc_SetLocateState(module_slot, 1)
    print("Slot {}: Locating...".format(module_slot))
    input("Press enter to stop locate.")
    device.ioThinx_Misc_SetLocateState(module_slot, 0)
    rs_state = device.ioThinx_Misc_GetRotarySwitchState(misc_slot)
    print("Rotary switch state = {}".format(rs_state))

    # push button
    pbtn_state = device.ioThinx_Misc_GetPushButtonState(misc_slot)
    print("Push button state = {}".format(pbtn_state))

    # user led
    device.ioThinx_Misc_SetUserLedState(misc_slot, LED_CHANNEL_U1, LED_STATE_GREEN)
    print("Set LED U1 to GREEN")
    device.ioThinx_Misc_SetUserLedState(misc_slot, LED_CHANNEL_U2, LED_STATE_RED)
    print("Set LED U2 to RED")
    input("Press enter to clear.")
    device.ioThinx_Misc_SetUserLedState(misc_slot, LED_CHANNEL_U1, LED_STATE_DARK)
    device.ioThinx_Misc_SetUserLedState(misc_slot, LED_CHANNEL_U2, LED_STATE_DARK)
    input("Press enter to continue.")


if __name__ == '__main__':
    main()
