'''
    Copyright (C) 2019 Moxa Inc. All rights reserved.
    SPDX-License-Identifier: Apache-2.0

    TC Python Sample Application

    Date          Author            Comment
    2019-02-11    William Chang     Created it.
'''

##
# @file tc.py
# @copyright 2019 Moxa Inc. All rights reserved.
# @date 2019-02-11
# @author William Chang
# @version V1.0
# @brief <b>TC Sample</b>
# @details <b>Library:</b><br>
# @link TC TC APIs @endlink
# @include tc.py

from ioThinx_4530 import ioThinx_4530_API
import argparse

TC_SENSOR_TYPE_K = 1


def main():
    parser = argparse.ArgumentParser(description="TC sample program.")
    parser.add_argument("-s", "--slot", dest="tc_slot", type=int, default=7)
    parser.add_argument("-c", "--channel_start", dest="tc_channel_start", type=int, default=0)
    parser.add_argument("-n", "--channel_count", dest="tc_channel_count", type=int, default=2)
    args = parser.parse_args()

    tc_slot = args.tc_slot
    tc_channel_start = args.tc_channel_start
    tc_channel_count = args.tc_channel_count
    print("TC slot =  {}".format(tc_slot))
    print("TC start channel = {}".format(tc_channel_start))
    print("TC channel count = {}".format(tc_channel_count))

    # initialize ioThinx I/O
    device = ioThinx_4530_API.ioThinx_4530_API()

    # temporarily set config
    tc_types = [TC_SENSOR_TYPE_K] * tc_channel_count
    device.ioThinx_TC_Config_SetSensorTypes(tc_slot, tc_channel_start, tc_channel_count, tc_types)

    # reload config
    device.ioThinx_IO_Config_Reload()

    # get value
    while True:
        tc_values = device.ioThinx_TC_GetValues(tc_slot, tc_channel_start, tc_channel_count)
        tc_statuss = device.ioThinx_TC_GetStatuss(tc_slot, tc_channel_start, tc_channel_count)
        for i in range(tc_channel_count):
            print("[ {}:{}] value = {}, status =  {}".format(tc_slot, tc_channel_start + i, tc_values[i], tc_statuss[i]))
        if input("Press 'q' to exit. other keys to continue") == 'q':
            break


if __name__ == '__main__':
    main()
