'''
    Copyright (C) 2019 Moxa Inc. All rights reserved.
    SPDX-License-Identifier: Apache-2.0

    RTD Python Sample Application

    Date          Author            Comment
    2019-02-11    William Chang     Created it.
'''

##
# @file rtd.py
# @copyright 2019 Moxa Inc. All rights reserved.
# @date 2019-02-11
# @author William Chang
# @version V1.0
# @brief <b>RTD Sample</b>
# @details <b>Library:</b><br>
# @link RTD RTD APIs @endlink
# @include rtd.py

from ioThinx_4530 import ioThinx_4530_API
import argparse

RTD_SENSOR_TYPE_PT100 = 1


def main():
    parser = argparse.ArgumentParser(description="RTD sample program.")
    parser.add_argument("-s", "--slot", dest="rtd_slot", type=int, default=8)
    parser.add_argument("-c", "--channel_start", dest="rtd_channel_start", type=int, default=0)
    parser.add_argument("-n", "--channel_count", dest="rtd_channel_count", type=int, default=2)
    args = parser.parse_args()

    rtd_slot = args.rtd_slot
    rtd_channel_start = args.rtd_channel_start
    rtd_channel_count = args.rtd_channel_count
    print("RTD slot =  {}".format(rtd_slot))
    print("RTD start channel = {}".format(rtd_channel_start))
    print("RTD channel count = {}".format(rtd_channel_count))

    # initialize ioThinx I/O
    device = ioThinx_4530_API.ioThinx_4530_API()

    # temporarily set config
    rtd_types = [RTD_SENSOR_TYPE_PT100] * rtd_channel_count

    device.ioThinx_RTD_Config_SetSensorTypes(rtd_slot, rtd_channel_start, rtd_channel_count, rtd_types)

    # reload config
    device.ioThinx_IO_Config_Reload()

    # get value
    while True:
        rtd_values = device.ioThinx_RTD_GetValues(rtd_slot, rtd_channel_start, rtd_channel_count)
        rtd_statuss = device.ioThinx_RTD_GetStatuss(rtd_slot, rtd_channel_start, rtd_channel_count)
        for i in range(rtd_channel_count):
            print("[ {}:{}] value = {}, status =  {}".format(rtd_slot, rtd_channel_start + i, rtd_values[i], rtd_statuss[i]))
        if input("Press 'q' to exit. other keys to continue") == 'q':
            break


if __name__ == '__main__':
    main()
