'''
    Copyright (C) 2019 Moxa Inc. All rights reserved.
    SPDX-License-Identifier: Apache-2.0

    Relay Python Sample Application

    Date          Author            Comment
    2019-02-11    William Chang     Created it.
'''

##
# @file relay.py
# @copyright 2019 Moxa Inc. All rights reserved.
# @date 2019-02-11
# @author William Chang
# @version V1.0
# @brief <b>Relay Sample</b>
# @details <b>Library:</b><br>
# @link Relay Relay APIs @endlink
# @include relay.py

from ioThinx_4530 import ioThinx_4530_API
import argparse


def main():
    parser = argparse.ArgumentParser(description="Relay sample program.")
    parser.add_argument("-s", "--slot", dest="relay_slot", type=int, default=6)
    parser.add_argument("-c", "--channel", dest="relay_channel", type=int, default=3)
    args = parser.parse_args()

    relay_slot = args.relay_slot
    relay_channel = args.relay_channel
    relay_values = 0
    print("Relay slot =  {}", relay_slot)
    print("Relay channel = {}", relay_channel)

    # initialize ioThinx I/O
    device = ioThinx_4530_API.ioThinx_4530_API()
    relay_values = device.ioThinx_Relay_GetValues(relay_slot)
    print(relay_values)

    # set value
    while True:
        # invert relay value
        relay_values[relay_channel] = 0 if relay_values[relay_channel] == 1 else 1

        device.ioThinx_Relay_SetValues(relay_slot, relay_values)
        print("[ {}:{}] relay value = {}".format(relay_slot, relay_channel, relay_values))

        relay_count = device.ioThinx_Relay_GetCurrentCounts(relay_slot, relay_channel, 1)
        print("[ {}:{}] relay count =  {}".format(relay_slot, relay_channel, relay_count))
        if input("Press 'q' to exit. other keys to continue") == 'q':
            break


if __name__ == '__main__':
    main()
