'''
    Copyright (C) 2019 Moxa Inc. All rights reserved.
    SPDX-License-Identifier: Apache-2.0

    Power Diagnostic Python Sample Application

    Date          Author            Comment
    2019-02-11    William Chang     Created it.
'''

##
# @file pwr.py
# @copyright 2019 Moxa Inc. All rights reserved.
# @date 2019-02-11
# @author William Chang
# @version V1.0
# @brief <b>Power Sample</b>
# @details <b>Library:</b><br>
# @link Power Power APIs @endlink
# @include pwr.py

from ioThinx_4530 import ioThinx_4530_API
import argparse


def main():
    parser = argparse.ArgumentParser(description="PWR sample program.")
    parser.add_argument("-s", "--slot", dest="pwr_slot", type=int, default=11)
    parser.add_argument("-a", "--alarm_voltage", dest="alarm_voltage", type=int, default=20.0)
    args = parser.parse_args()

    pwr_slot = args.pwr_slot
    alarm_voltage = args.alarm_voltage
    sys_channel = 0
    field_channel = 0
    sys_status = 0
    field_status = 0
    print("Power slot =  {}".format(pwr_slot))
    print("Alarm setting = {}".format(alarm_voltage))

    # initialize ioThinx I/O
    device = ioThinx_4530_API.ioThinx_4530_API()

    # temporarily set config
    device.ioThinx_PWR_Config_SetAlarms(pwr_slot, field_channel, 1, [alarm_voltage])

    # reload config
    device.ioThinx_IO_Config_Reload()

    while True:
        sys_status = device.ioThinx_PWR_GetSysStatus(pwr_slot, sys_channel, 1)
        field_status = device.ioThinx_PWR_GetFieldStatus(pwr_slot, field_channel, 1)
        print("[ {}] system power status = {}".format(pwr_slot, sys_status))
        print("[ {}] filed power status = {}".format(pwr_slot, field_status))
        if input("Press 'q' to exit. other keys to continue") == 'q':
            break


if __name__ == '__main__':
    main()
