'''
    Copyright (C) 2019 Moxa Inc. All rights reserved.
    SPDX-License-Identifier: Apache-2.0

    PWM Python Sample Application

    Date          Author            Comment
    2019-02-11    William Chang     Created it.
'''

##
# @file pwm.py
# @copyright 2019 Moxa Inc. All rights reserved.
# @date 2019-02-11
# @author William Chang
# @version V1.0
# @brief <b>PWM Sample</b>
# @details <b>Library:</b><br>
# @link DO DO APIs @endlink
# @include pwm.py

from ioThinx_4530 import ioThinx_4530_API
import argparse

DO_MODE_PWM = 1


def main():
    parser = argparse.ArgumentParser(description="PWM sample program.")
    parser.add_argument("-s", "--slot", dest="do_slot", type=int, default=3)
    parser.add_argument("-c", "--channel_start", dest="pwm_channel_start", type=int, default=0)
    parser.add_argument("-n", "--channel_count", dest="pwm_channel_count", type=int, default=2)
    args = parser.parse_args()

    do_slot = args.do_slot
    pwm_channel_start = args.pwm_channel_start
    pwm_channel_count = args.pwm_channel_count
    print("DO slot =  {}".format(do_slot))
    print("PWM start channel = {}".format(pwm_channel_start))
    print("PWM channel count = {}".format(pwm_channel_count))

    # initialize ioThinx I/O
    device = ioThinx_4530_API.ioThinx_4530_API()

    # temporarily set config
    do_modes = [DO_MODE_PWM] * pwm_channel_count
    device.ioThinx_DO_Config_SetModes(do_slot, pwm_channel_start, pwm_channel_count, do_modes)

    pwm_counts = [0] * pwm_channel_count  # infinite
    device.ioThinx_DO_Config_SetPwmCounts(do_slot, pwm_channel_start, pwm_channel_count, pwm_counts)
    pwm_freqs = [5] * pwm_channel_count
    pwm_dutys = [50] * pwm_channel_count
    device.ioThinx_DO_Config_SetPwmConfigures(do_slot, pwm_channel_start, pwm_channel_count, pwm_freqs, pwm_dutys)

    # reload config
    device.ioThinx_IO_Config_Reload()

    # start pwm
    pwm_starts = [0] * 4
    for i in range(pwm_channel_start, pwm_channel_start + pwm_channel_count):
        pwm_starts[i] = 1
    device.ioThinx_DO_SetPwmStarts(do_slot, pwm_starts)

    # set value
    while True:
        pwm_dutys[0] = 0 if (pwm_dutys[0] >= 100) else pwm_dutys[0] + 10   # runtime adjust the duty cycle
        device.ioThinx_DO_SetPwmConfigures(do_slot, pwm_channel_start, pwm_channel_count, pwm_freqs, pwm_dutys)
        for i in range(pwm_channel_count):
            print("[ {}:{}] frequency =  {}, duty cycle =  {}".format(do_slot, pwm_channel_start + i, pwm_freqs[i], pwm_dutys[i]))

        if input("Press 'q' to exit. other keys to continue") == 'q':
            break

    device.ioThinx_DO_SetPwmStops(do_slot, pwm_starts)


if __name__ == '__main__':
    main()
