'''
    Copyright (C) 2019 Moxa Inc. All rights reserved.
    SPDX-License-Identifier: Apache-2.0

    DO Python Sample Application

    Date          Author            Comment
    2019-02-11    William Chang     Created it.
'''

##
# @file do.py
# @copyright 2019 Moxa Inc. All rights reserved.
# @date 2019-02-11
# @author William Chang
# @version V1.0
# @brief <b>DO Sample</b>
# @details <b>Library:</b><br>
# @link DO DO APIs @endlink
# @include do.py

from ioThinx_4530 import ioThinx_4530_API
import argparse


def main():
    parser = argparse.ArgumentParser(description="DO sample program.")
    parser.add_argument("-s", "--slot", dest="do_slot", type=int, default=1)
    parser.add_argument("-c", "--channel", dest="do_channel", type=int, default=0)
    args = parser.parse_args()

    do_slot = args.do_slot
    do_channel = args.do_channel
    do_count = 1
    do_mode = [0] * do_count
    do_values = 0
    print("DO slot =  {}".format(do_slot))
    print("DO channel = {}".format(do_channel))

    # initialize ioThinx I/O
    device = ioThinx_4530_API.ioThinx_4530_API()

    # temporarily set config
    device.ioThinx_DO_Config_SetModes(do_slot, do_channel, do_count, do_mode)

    # reload config
    device.ioThinx_IO_Config_Reload()
    do_values = device.ioThinx_DO_GetValues(do_slot)
    print("do_values = {}".format(do_values))

    # set value
    while True:
        # invert do value
        if do_values[do_channel] == 0:
            do_values[do_channel] = 1
        else:
            do_values[do_channel] = 0
        device.ioThinx_DO_SetValues(do_slot, do_values)
        print("[ {}:{}] DO value = {}".format(do_slot, do_channel, do_values[do_channel]))
        if input("Press 'q' to exit. other keys to continue") == 'q':
            break


if __name__ == '__main__':
    main()
