'''
    Copyright (C) 2019 Moxa Inc. All rights reserved.
    SPDX-License-Identifier: Apache-2.0

    DI Python Sample Application

    Date          Author            Comment
    2019-02-11    William Chang     Created it.
'''

##
# @file di.py
# @copyright 2019 Moxa Inc. All rights reserved.
# @date 2019-02-11
# @author William Chang
# @version V1.0
# @brief <b>DI Sample</b>
# @details <b>Library:</b><br>
# @link DI DI APIs @endlink
# @include di.py

from ioThinx_4530 import ioThinx_4530_API
import argparse


def main():
    parser = argparse.ArgumentParser(description="Counter sample program.")
    parser.add_argument("-s", "--slot", dest="di_slot", type=int, default=1)
    parser.add_argument("-c", "--channel", dest="di_channel", type=int, default=0)
    parser.add_argument("-f", "--filter", dest="di_filter", type=int, default=2)
    args = parser.parse_args()

    di_slot = args.di_slot
    di_channel = args.di_channel
    di_count = 1
    di_filter = [args.di_filter] * di_count
    print("DI slot =  {}".format(di_slot))
    print("DI channel = {}".format(di_channel))
    print("DI filter = {}".format(di_filter))

    # initialize ioThinx I/O
    device = ioThinx_4530_API.ioThinx_4530_API()

    # temporarily set config
    device.ioThinx_DI_Config_SetFilters(di_slot, di_channel, di_count, di_filter)

    # reload config
    device.ioThinx_IO_Config_Reload()

    while True:
        di_values = device.ioThinx_DI_GetValues(di_slot)
        print("[ {}] di_values = {}".format(di_slot, di_values))
        print("[ {}:{}] di_val = {}".format(di_slot, di_channel, di_values))
        if input("Press 'q' to exit. other keys to continue") == 'q':
            break


if __name__ == '__main__':
    main()
