'''
    Copyright (C) 2019 Moxa Inc. All rights reserved.
    SPDX-License-Identifier: Apache-2.0

    Counter Python Sample Application

    Date          Author            Comment
    2019-02-11    William Chang     Created it.
'''

##
# @file counter.py
# @copyright 2019 Moxa Inc. All rights reserved.
# @date 2019-02-11
# @author William Chang
# @version V1.0
# @brief <b>Counter Sample</b>
# @details <b>Library:</b><br>
# @link DI DI APIs @endlink
# @include counter.py

from ioThinx_4530 import ioThinx_4530_API
import argparse

DI_MODE_COUNTER = 1
CNT_TRIGGER_BOTH = 2


def main():
    parser = argparse.ArgumentParser(description="Counter sample program.")
    parser.add_argument("-s", "--slot", dest="di_slot", type=int, default=11)
    parser.add_argument("-c", "--channel_start", dest="counter_channel_start", type=int, default=0)
    parser.add_argument("-n", "--channel_count", dest="counter_channel_count", type=int, default=2)
    args = parser.parse_args()

    di_slot = args.di_slot
    counter_channel_start = args.counter_channel_start
    counter_channel_count = args.counter_channel_count
    print("DI slot =  {}".format(di_slot))
    print("Counter start channel = {}".format(counter_channel_start))
    print("Counter channel count = {}".format(counter_channel_count))

    # initialize ioThinx I/O
    device = ioThinx_4530_API.ioThinx_4530_API()

    # temporarily set config
    di_modes = [DI_MODE_COUNTER] * counter_channel_count
    device.ioThinx_DI_Config_SetModes(di_slot, counter_channel_start, counter_channel_count, di_modes)

    counter_triggers = [CNT_TRIGGER_BOTH] * counter_channel_count
    device.ioThinx_DI_Config_SetCntTriggers(di_slot, counter_channel_start, counter_channel_count, counter_triggers)
    counter_values = [0] * counter_channel_count
    device.ioThinx_DI_Config_SetCntValues(di_slot, counter_channel_start, counter_channel_count, counter_values)

    # reload config
    device.ioThinx_IO_Config_Reload()

    # start counter
    counter_start = [0] * 4
    for i in range(counter_channel_start, counter_channel_start + counter_channel_count):
        counter_start[i] = 1
    device.ioThinx_DI_SetCntStarts(di_slot, counter_start)

    # get value
    while True:
        counter_values = device.ioThinx_DI_GetCntValues(di_slot, counter_channel_start, counter_channel_count)
        for i in range(counter_channel_count):
            print("[ {}:{}] counter =  {}".format(di_slot, counter_channel_start + i, counter_values[i]))

        if input("Press 'q' to exit. other keys to continue") == 'q':
            break


if __name__ == '__main__':
    main()
