'''
    Copyright (C) 2019 Moxa Inc. All rights reserved.
    SPDX-License-Identifier: Apache-2.0

    AO Python Sample Application

    Date          Author            Comment
    2019-07-30    William Chang     Created it.
'''

##
# @file ao.py
# @copyright 2019 Moxa Inc. All rights reserved.
# @date 2019-07-30
# @author William Chang
# @version V1.0
# @brief <b>AO Sample</b>
# @details <b>Library:</b><br>
# @link AO AO APIs @endlink
# @include ao.py

from ioThinx_4530 import ioThinx_4530_API
from time import sleep
import argparse

AO_RANGE_4_20mA = 3


def main():
    parser = argparse.ArgumentParser(description="AO sample program.")
    parser.add_argument("-s", "--slot", dest="ao_slot", type=int, default=8)
    parser.add_argument("-c", "--channel_start", dest="ao_channel_start", type=int, default=0)
    parser.add_argument("-n", "--channel_count", dest="ao_channel_count", type=int, default=4)
    args = parser.parse_args()

    ao_slot = args.ao_slot
    ao_channel_start = args.ao_channel_start
    ao_channel_count = args.ao_channel_count
    print("AO slot =  {}".format(ao_slot))
    print("AO start channel = {}".format(ao_channel_start))
    print("AO channel count = {}".format(ao_channel_count))

    # initialize ioThinx I/O
    device = ioThinx_4530_API.ioThinx_4530_API()

    # temporarily set config
    ao_ranges = [AO_RANGE_4_20mA] * ao_channel_count
    device.ioThinx_AO_Config_SetRanges(ao_slot, ao_channel_start, ao_channel_count, ao_ranges)

    # reload config
    device.ioThinx_IO_Config_Reload()

    # set value
    ao_raws = [2048] * ao_channel_count    
    device.ioThinx_AO_SetRaws(ao_slot, ao_channel_start, ao_channel_count, ao_raws);
    # wait for signal stable
    sleep(1);


    # get value
    while True:
        ao_engs = device.ioThinx_AO_GetEngs(ao_slot, ao_channel_start, ao_channel_count, )
        ao_statuss = device.ioThinx_AO_GetStatuss(ao_slot, ao_channel_start, ao_channel_count, )
        for i in range(ao_channel_count):
            print("[ {}:{}] eng = {}, status =  {}".format(ao_slot, ao_channel_start + i, ao_engs[i], ao_statuss[i]))
        if input("Press 'q' to exit. other keys to continue") == 'q':
            break


if __name__ == '__main__':
    main()
