'''
    Copyright (C) 2019 Moxa Inc. All rights reserved.
    SPDX-License-Identifier: Apache-2.0

    AI Python Sample Application

    Date          Author            Comment
    2019-02-11    William Chang     Created it.
'''

##
# @file ai.py
# @copyright 2019 Moxa Inc. All rights reserved.
# @date 2019-02-11
# @author William Chang
# @version V1.0
# @brief <b>AI Sample</b>
# @details <b>Library:</b><br>
# @link AI AI APIs @endlink
# @include ai.py

from ioThinx_4530 import ioThinx_4530_API
import argparse

AI_RANGE_4_20mA_BURNOUT = 3


def main():
    parser = argparse.ArgumentParser(description="AI sample program.")
    parser.add_argument("-s", "--slot", dest="ai_slot", type=int, default=1)
    parser.add_argument("-c", "--channel_start", dest="ai_channel_start", type=int, default=0)
    parser.add_argument("-n", "--channel_count", dest="ai_channel_count", type=int, default=8)
    args = parser.parse_args()

    ai_slot = args.ai_slot
    ai_channel_start = args.ai_channel_start
    ai_channel_count = args.ai_channel_count
    print("AI slot =  {}".format(ai_slot))
    print("AI start channel = {}".format(ai_channel_start))
    print("AI channel count = {}".format(ai_channel_count))

    # initialize ioThinx I/O
    device = ioThinx_4530_API.ioThinx_4530_API()

    # temporarily set config
    ai_ranges = [AI_RANGE_4_20mA_BURNOUT] * ai_channel_count
    device.ioThinx_AI_Config_SetRanges(ai_slot, ai_channel_start, ai_channel_count, ai_ranges)
    ai_burnouts = [2.0] * ai_channel_count
    device.ioThinx_AI_Config_SetBurnoutValues(ai_slot, ai_channel_start, ai_channel_count, ai_burnouts)

    # reload config
    device.ioThinx_IO_Config_Reload()

    # get value
    while True:
        ai_engs = device.ioThinx_AI_GetEngs(ai_slot, ai_channel_start, ai_channel_count, )
        ai_statuss = device.ioThinx_AI_GetStatuss(ai_slot, ai_channel_start, ai_channel_count, )
        for i in range(ai_channel_count):
            print("[ {}:{}] eng = {}, status =  {}".format(ai_slot, ai_channel_start + i, ai_engs[i], ai_statuss[i]))
        if input("Press 'q' to exit. other keys to continue") == 'q':
            break


if __name__ == '__main__':
    main()
