'''
    Copyright (C) 2019 Moxa Inc. All rights reserved.
    SPDX-License-Identifier: Apache-2.0

    Serial Python Sample Application

    Date          Author            Comment
    2019-02-11    William Chang     Created it
    2020-09-15    KevinYK Lin       Modify it
'''

##
# @file serial_sample.py
# @copyright 2019 Moxa Inc. All rights reserved.
# @date 2020-04-13
# @author KevinYK Lin
# @version V2.0
# @brief <b>Seial Sample</b>
# @details <b>Library:</b><br>
# @link Seial Seial APIs @endlink
# @include serial_sample.py

from ioThinx_4530 import ioThinx_4530_API
import serial
import argparse
import os

BUF_LEN = 4096
SERIAL_MODE_RS232 = 0
SERIAL_SLOT_0 = 0
SERIAL_PORT_0 = 0



def main():
    parser = argparse.ArgumentParser(description="Miscellaneous sample program.")
    parser.add_argument("-b", "--baudrate", dest="serial_baudrate", type=int, default=115200)
    parser.add_argument("-s", "--slot", dest="serial_slot", type=int, default=SERIAL_SLOT_0)
    parser.add_argument("-p", "--port", dest="serial_port", type=int, default=SERIAL_PORT_0)
    parser.add_argument("-m", "--mode", dest="serial_mode", type=int, default=SERIAL_MODE_RS232)
    args = parser.parse_args()

    serial_slot = args.serial_slot
    serial_port = args.serial_port
    serial_mode = args.serial_mode
    serial_baudrate = args.serial_baudrate
    print("serial slot = {}".format(serial_slot))
    print("serial port = {}".format(serial_port))
    print("serial mode = {}".format(serial_mode))
    print("serial baudrate = {}".format(serial_baudrate))

    device = ioThinx_4530_API.ioThinx_4530_API()
    ioThinx_4530_API.ioThinx_4530_API().ioThinx_Serial_SetInterface(serial_slot, serial_port, serial_mode)
    interface =ioThinx_4530_API.ioThinx_4530_API().ioThinx_Serial_GetInterface(serial_slot, serial_port)
    print("interface ={}".format(interface))
    devname_array = str(ioThinx_4530_API.ioThinx_4530_API().ioThinx_Serial_GetDevName(serial_slot, serial_port))
                            
    DevName = ""
    for ele in devname_array:
        if(ele == "\x00"):
            break
        DevName += ele
    print("DevName ={}".format(DevName))
    # baudrate,flow control,parity,data bits,stop bit
    # please refer to pyserial documents
    fd = serial.Serial(DevName, serial_baudrate, timeout=1)

    print("fd = {}".format(fd))
    print("Start Serial echo.")    
    
    while True:
        buf = fd.readline()
        print(len(buf))
        print(buf)
        if len(buf) > 0:
            fd.write(buf)            
            if 'quit' in buf.decode():
                break

    print("Stop Serial echo.")
    fd.close()


if __name__ == '__main__':
    main()
