#!/bin/bash

LOG_FILE="/var/lib/defender_iot_micro_agent/pam.log"
DATE_ISO=`date --iso-8601="seconds"`
TIMEVAL=`date +%s,%N`

# for easier parsing
if [ -z "${PAM_RHOST}" ]; then
    PAM_RHOST="-" 
fi
if [ -z "${PAM_TTY}" ]; then
    PAM_TTY="-" 
fi

LOG_ENTRY="${DATE_ISO},${TIMEVAL},${PAM_TYPE},${PAM_SERVICE},${PAM_USER},${PAM_RHOST},${PAM_TTY},$1"

if [ ! -f ${LOG_FILE} ]; then
	touch ${LOG_FILE}
	chown root:adm ${LOG_FILE}
	chmod 0640 ${LOG_FILE}
fi

echo ${LOG_ENTRY} >> ${LOG_FILE}

exit 0
