#define	MXSER_BOARDS	4
#define MXSER_PORTS_PER_BOARD	8

static char *mxser_brdname[] = {
	"Moxa C168 ISA series",
	"Moxa C104 ISA series",
    	"Moxa CI-104J series",
	"Moxa C168H/PCI series",
	"Moxa C104H/PCI series",
	"Moxa C102 series",
	"Moxa CI-132 series",
	"Moxa CI-134 series",
	"Moxa CP-132 series",
	"Moxa CP-114 series",
	"Moxa CT-114 series",
	"Moxa CP-104U series",
	"Moxa CP-168U series",
	"Moxa CP-132U series",
	"Moxa CP-134U series",
	"Moxa CP-104JU series",
	"Moxa CP-102 series",
	/* Starting add by Danny Lin. 2004.7.21 */
	"Moxa CP-118U series",
	"Moxa CP-102UL series",
	"Moxa CP-102U series",
	/* Ending add by Danny Lin. 2004.7.21 */
	/* Starting add by Danny Lin. 2005.12.15 */
	"Moxa CP-118EL series",
	"Moxa CP-168EL series",
	"Moxa CP-104EL series",
	/* Ending add by Danny Lin. 2005.12.15 */
};

struct mxser_hwconf {
	int	board_type;
	int 	ports;
	int 	irq;
	int 	vector;
	int 	vector_mask;
	int 	uart_type;
	int 	ioaddr[MXSER_PORTS_PER_BOARD];
	int 	baud_base[MXSER_PORTS_PER_BOARD];
	int	IsMoxaMustChipFlag;
	int	MaxCanSetBaudRate[MXSER_PORTS_PER_BOARD];
};

static struct mxser_hwconf mxsercfg[MXSER_BOARDS]; 

#define MOXA_GET_MAJOR	_IOR('t', 200, int)
#define MOXA_GET_CONF	_IOR('t', 201, mxsercfg)
