
/*****************************************************************************/
/* DIAG.C                                                                    */
/*									     */
/* Copyright (c) Moxa Technologies Inc. 1999. All Rights Reserved.	     */
/*									     */
/* Revision history:							     */
/*     8/5/99   Casper                                                       */
/*     3/9/2001 Casper     add Industio                                      */
/*****************************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <sys/ioccom.h>
#include "diag.h"

#define DIAG_VER "1.2"
/*
#include "../global.h"
*/

int main()
{
	int	fd;
	int	i, j;
	int	ports;
    	int     major;
	char    title_str[80];

	struct mxser_hwconf mxsercfg[MXSER_BOARDS];

	sprintf(title_str, "\n== MOXA Smartio/Industio Family Multiport Board Status Utility(%s) ==\n", DIAG_VER);

	printf(title_str);

	if((fd = open("/dev/mxser", O_RDWR)) < 0){
	    printf("Open /dev/mxser fail\n");
            printf("Please load driver first.\n");
	    return 1;
	}

	if(ioctl(fd, MOXA_GET_MAJOR, &major) < 0 ) {
            printf("Can't get tty major number.\n");
            close(fd);
            return 1;
    	}
    	printf("Tty Device Major Number= %d\n", major);

	bzero(mxsercfg, 4*sizeof(struct mxser_hwconf));
	if(ioctl(fd, MOXA_GET_CONF, mxsercfg)<0){
            printf("Can't get driver configuration.\n");
            close(fd);
            return 1;
        }

	for(i=0; i<MXSER_BOARDS; i++){

	    if(mxsercfg[i].board_type == 0)
	        continue;
    
        printf("Board %d : %s\n", i+1, 
				mxser_brdname[mxsercfg[i].board_type-1]);

	    ports = mxsercfg[i].ports;
	    for(j=0; j<ports && j<MXSER_PORTS_PER_BOARD; j++) {
			printf("\tPort %d: 0x%x, max. baud rate = %d bps.\n",
					j+1, (mxsercfg[i].ioaddr[0] + 8*j),
					mxsercfg[i].baud_base[0]);
		}
	}

	close(fd);
    return 0;
}
