﻿using System;
using System.Runtime.InteropServices;

namespace mx_watchdog_ctl
{
    class Program
    {
        [DllImport("mxwdg.dll")]
        public static extern IntPtr mxwdg_open(long time);

        [DllImport("mxwdg.dll")]
        public static extern void mxwdg_close(IntPtr fd);

        [DllImport("mxwdg.dll")]
        public static extern int mxwdg_refresh(IntPtr fd);

        static private IntPtr _fd;

        static void Main(string[] args)
        {
            long time = 10;

            /* starts watchdog timer */
            if (!Open(time))
            {
                System.Console.WriteLine("Unable to open device.\n");
                return;
            }

            while (true)
            {
                Console.WriteLine("Press \"ENTER\" in 10 seconds\n, 'q' to exit");
                char ch = Console.ReadKey().KeyChar;

                if (ch == 'q')
                {
                    break;
                }

                /* refresh watchdog timer */
                Refresh();
            }

            /* stops watchdog timer */
            Close();
            return;

        }

        static public bool Open(long time)
        {
            _fd = mxwdg_open(time);
            return true;
        }

        static public void Close()
        {
            mxwdg_close(_fd);
        }

        static public int Refresh()
        {
            int returnValue = 0;

            returnValue = mxwdg_refresh(_fd);

            return returnValue;
        }

    }
}
