/*
Copyright (C) MOXA Inc. All rights reserved.

This software is distributed under the terms of the
MOXA License.  See the file COPYING-MOXA for details.
*/

#include <windows.h>

#ifdef __cplusplus    // If used by C++ code, 
extern "C" {          // we need to export the C interface
#endif

	/**
	* Open Watchdog
	* @param  [in] time - initial refresh time, the unit is second
	* @return Pointer to Watchdog handle. Return -1 on failure.
	*/
	PVOID mxwdg_open(unsigned long time);

	/**
	* Refresh the watchdog timer
	* @param  [in] fd - the handle
	* @return 0 on success, otherwise the function fails
	*/
	int mxwdg_refresh(PVOID fd);

	/**
	* Close Watchdog
	* @param  [in] fd - the handle
	* @return None
	*/
	void mxwdg_close(PVOID fd);
#ifdef __cplusplus    // If used by C++ code, 
}
#endif
