// SerialInterface.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <windows.h>
#include "..\\Include\\mxdev.h"

#define MAX_SERIAL_PORT_NUMBER 2

int _tmain(int argc, _TCHAR* argv[])
{
	char	*interface_array[] = { "RS232", "RS485-2W", "RS422", "RS485-4W" }; //{RS232, RS485-2W, RS485-4W, RS485-4W}
	HANDLE	hSerial;
	int		port_no;
	int		nRet = 0;
	int		port = 0, mode = 0;
	int		n=0;

	int port_index = 0 ,port_interface = 0;
	WCHAR sin,smode;

	printf("Serial Interface Test Program\n");
    printf("\t (0) Exit Program\n");
    printf("\t (1) Display Serial Interface\n");
   	printf("\t (2) Set Serial Interface\n");

	sin=getwchar();
	n=_wtoi(&sin);
	
	do
    {
        switch (n)
        {
            // if char == '1', display the serial interface
            case 1:
				//Open serial port
				hSerial = mxsp_open();

				for(int i=0;i<MAX_SERIAL_PORT_NUMBER;i++)
				{
					//Get serial interface
					port_no = i + 1;
					port_interface = mxsp_get_interface(hSerial,port_no);
					printf("COM%d = %s\n",port_no, interface_array[port_interface]);
				}

				//Close DIO
                mxsp_close(hSerial);
                break;

			 // if char == '2', Set the serial interface
            case 2:
             
				//Get Port Number
				getwchar();
				printf("Input the Port Number (1 ~ %d) = \n",MAX_SERIAL_PORT_NUMBER);
				smode = getwchar();
				port_index =_wtoi(&smode);
			
				//Get Value
                getwchar();
				printf("Input the value (0:RS232, 1:RS485-2W, 2:RS422 3:RS485-4W ) = ");
				smode = getwchar();
				port_interface = _wtoi(&smode);
		
				//Open serial port
				hSerial = mxsp_open();
				
				//Set serial interface
				nRet = mxsp_set_interface(hSerial,port_index ,port_interface);
				
				
				if(nRet == -1)
				{
					printf("Set serial interface fail!\n");
				}
				else
				{
					printf("Set serial interface success!\n");
				}

				//Close serial port
				mxsp_close(hSerial);
                break;

			
        }
		getwchar();
        sin = getwchar();
        n = _wtoi(&sin);
    } while (n != 0);

	return 0;
}

