﻿/*
  Copyright (C) MOXA Inc. All rights reserved.
  This software is distributed under the terms of the
  MOXA License.  See the file COPYING-MOXA for details.
*/

/**
 * @file mxDev.cs -- interface of the Moxa proprietary device library
 *
 * @version 1.0.0.0 - 2013/07/05
 *
 * @author holsety.chen@moxa.com
 */

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace mxdev_csif
{
    [Flags]
    public enum _SERIALIF_MODE_
    {
        SIF_MODE_RS232 = 0,
        SIF_MODE_RS485_2W,
        SIF_MODE_RS422,
        SIF_MODE_RS485_4W,

        SIF_MODE_UNKNOWN
    };

    /// <summary>
    /// Moxa Proprietary Device C Sharp Interface.
    /// </summary>
    public class mxdev
    {
        /// <summary>
        /// Open DIO port
        /// </summary>
        /// <returns>Pointer to DIO handle. Return -1 on failure.</returns>
        /// 
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern IntPtr mxdgio_open();

        /// <summary>
        /// Close DIO port
        /// </summary>
        /// <param name="fd">the handle</param>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern void mxdgio_close(IntPtr fd);

        /// <summary>
        /// Set the value HIGH to DO port
        /// </summary>
        /// <param name="fd">the Handle</param>
        /// <param name="port_no">the port number (started from 0)</param>
        /// <returns>0 on success, otherwise the function fails</returns>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern int mxdgio_set_output_signal_high(IntPtr fd, uint port_no);

        /// <summary>
        /// Set the value LOW to DO port
        /// </summary>
        /// <param name="fd">the Handle</param>
        /// <param name="port_no">the port number (started from 0)</param>
        /// <returns>0 on success, otherwise the function fails</returns>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern int mxdgio_set_output_signal_low(IntPtr fd, uint port_no);

        /// <summary>
        /// Set the value (HIGH or LOW) to DO port
        /// </summary>
        /// <param name="fd">the Handle</param>
        /// <param name="port_no">the port number (started from 0)</param>
        /// <param name="data">the port data, 1:HIGH, 0:LOW</param>
        /// <returns>0 on success, otherwise the function fails</returns>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern int mxdgio_set_output_signal(IntPtr fd, uint port_no, int data);

        /// <summary>
        /// Get the value (HIGH or LOW) from DI port
        /// </summary>
        /// <param name="fd">the handle</param>
        /// <param name="port_no">the port number (started from 0)</param>
        /// <returns>1 indicates HIGH, 0 indicates LOW, otherwise the function fails</returns>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern int mxdgio_get_input_signal(IntPtr fd, int port_no);

        /// <summary>
        /// Get the value (HIGH or LOW) from DO port
        /// </summary>
        /// <param name="fd">the handle</param>
        /// <param name="port_no">the port number (started from 0)</param>
        /// <returns>1 indicates HIGH, 0 indicates LOW, otherwise the function fails</returns>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern int mxdgio_get_output_signal(IntPtr fd, int port_no);

        /// <summary>
        /// Open GPIO(LED) port
        /// </summary>
        /// <returns>Pointer to GPIO(LED) handle. Return -1 on failure.</returns>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern IntPtr mxgpio_open();

        /// <summary>
        /// Close GPIO(LED) port
        /// </summary>
        /// <param name="fd">the handle</param>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern void mxgpio_close(IntPtr fd);

        /// <summary>
        /// Set GPIO(LED) port mode
        /// </summary>
        /// <param name="fd">the handle</param>
        /// <param name="port_no">the port number (started from 0)</param>
        /// <param name="mode">1:Input, 0:Output</param>
        /// <returns>0 on success, otherwise the function fails</returns>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern int mxgpio_set_mode(IntPtr fd, uint port_no, int mode);

        /// <summary>
        /// Get GPIO(LED) port mode
        /// </summary>
        /// <param name="fd">the handle</param>
        /// <param name="port_no">the port number (started from 0)</param>
        /// <returns>1 indicates Input, 0 indicates Output, otherwise the function fails</returns>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern int mxgpio_get_mode(IntPtr fd, uint port_no);

        /// <summary>
        /// Set the value (HIGH or LOW) to GPIO(LED) port
        /// </summary>
        /// <param name="fd">the handle</param>
        /// <param name="port_no">the port number (started from 0)</param>
        /// <param name="data">the port data, 1:HIGH, 0:LOW</param>
        /// <returns>0 on success, otherwise the function fails</returns>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern int mxgpio_set_data(IntPtr fd, uint port_no, int data);

        /// <summary>
        /// Get the value (HIGH or LOW) to GPIO(LED) port
        /// </summary>
        /// <param name="fd">the handle</param>
        /// <param name="port_no">the port number (started from 0)</param>
        /// <returns>1 indicates HIGH, 0 indicates LOW, otherwise the function fails</returns>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern int mxgpio_get_data(IntPtr fd, uint port_no);

        /// <summary>
        /// Open serial interface mode driver for SUPERIO
        /// </summary>
        /// <returns>Pointer to serial mode handle. Return -1 on failure.</returns>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern IntPtr mxsp_open();

        /// <summary>
        /// Close serial interface mode driver
        /// </summary>
        /// <param name="fd">the handle</param>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern void mxsp_close(IntPtr fd);

        /// <summary>
        /// Get serial interface mode
        /// </summary>
        /// <param name="fd">the handle</param>
        /// <param name="port_index">port index</param>
        /// <returns>0 - RS232 Mode, 1 - RS485-2W Mode, 2 - RS422 Mode, 3 - RS485-4W Mode</returns>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern int mxsp_get_interface(IntPtr fd, int port_index);

        /// <summary>
        /// Set serial interface mode
        /// </summary>
        /// <param name="fd">the handle</param>
        /// <param name="port_index">port index</param>
        /// <param name="port_interface">0 - RS232 Mode, 1 - RS485-2W Mode, 2 - RS422 Mode, 3 - RS485-4W Mode</param>
        /// <returns>0 on success, otherwise the function fails</returns>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern int mxsp_set_interface(IntPtr fd, int port_index, int port_interface);

        /// <summary>
        /// Open Watchdog
        /// </summary>
        /// <param name="time">initial refresh time, the unit is second</param>
        /// <returns>Pointer to Watchdog handle. Return -1 on failure.</returns>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern IntPtr mxwdg_open(ulong time);

        /// <summary>
        /// Refresh the watchdog timer
        /// </summary>
        /// <param name="fd">the handle</param>
        /// <returns>0 on success, otherwise the function fails</returns>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern int mxwdg_refresh(IntPtr fd);

        /// <summary>
        /// Close Watchdog
        /// </summary>
        /// <param name="fd">the handle</param>
        [DllImport("mxdev.dll", SetLastError = true, CharSet = CharSet.Auto)]
        public static extern void mxwdg_close(IntPtr fd);

    }
}
