﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using mxdev_csif;

namespace SerialInterface
{
    class Program
    {
        static void Main(string[] args)
        {
            string [] interfaceArray = new string[]{"RS232","RS485 2 Wires","RS422","RS485 4 Wires"};
            IntPtr deviceHandle = IntPtr.Zero;
            bool quit = false;
            int portNum = 0;
            int interfaceMode = 0;

            do {
                Console.WriteLine("Serial Interface Test Program\n");
                Console.WriteLine("\t (0) Exit Program\n");
                Console.WriteLine("\t (1) Display Serial Interface\n");
   	            Console.WriteLine("\t (2) Set Serial Interface\n");
                string input = Console.ReadLine();
                switch(input)
                {
                    case "0":
                        quit = true;
                        break;

                    case "1":
                        deviceHandle = mxdev_csif.mxdev.mxsp_open();
                        for (int i=1;true;i++)
                        {
                            int mode = mxdev_csif.mxdev.mxsp_get_interface(deviceHandle, i);
                            if (mode<0)
                                break;
                            Console.WriteLine("COM{0} = {1}", i, interfaceArray[mode]);
                        }
                        mxdev_csif.mxdev.mxsp_close(deviceHandle);
                        break;

                    case "2":
                        Console.WriteLine("Input the Port Number (Start from 1): ");
                        try
                        {
                            portNum = Convert.ToInt32(Console.ReadLine());
                        }
                        catch
                        {
                            Console.WriteLine("Invalid Port Number!!");
                            break;
                        }

                        Console.WriteLine("Input the Mode:");
                        for (int i=0; i<interfaceArray.Count();i++)
                            Console.WriteLine("\t{0} = {1}", i, interfaceArray[i]);
                        try
                        {
                            interfaceMode = Convert.ToInt32(Console.ReadLine());
                        }
                        catch
                        {
                            Console.WriteLine("Invalid Interface Mode!!");
                            break;
                        }

                        deviceHandle = mxdev_csif.mxdev.mxsp_open();
                        if (0==mxdev_csif.mxdev.mxsp_set_interface(deviceHandle, portNum, interfaceMode))
                        {
                            Console.WriteLine("Set serial interface success!!");
                        }
                        else
                        {
                            Console.WriteLine("Set serial interface failed!!");
                        }
                        mxdev_csif.mxdev.mxsp_close(deviceHandle);

                        break;
                }
            } while(!quit);

        }
    }
}

