/*
 * Copyright (C) MOXA Inc. All rights reserved.
 * Authors:
 *     2022  Elvis Yao <ElvisCW.Yao@moxa.com>
 * This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
 * See the file MOXA-SOFTWARE-NOTICE for details.
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <termios.h>
#include <getopt.h>
#include <sys/ioctl.h>
#include "mx-app-wdt.h"

void usage()
{
	printf("Usage:\n");
	printf("	mx-app-wdtd [Options]...\n");
	printf("Options:\n");
	printf("	-t, --time_interval\n");
	printf("		Set app wdt tick daemon time interval (sec).\n");
	printf("	-h, --help\n");
	printf("		Show this help message.\n");
	printf( "\n");
}

int run_tick_deamon(int input_time) {
	int delay_time;

	if (input_time > 0) {
		delay_time = input_time;
		printf("Use tick time interval for %d sec.\n", delay_time);
	} else if (input_time < 0) {
		printf("Tick time interval must be greater than zero.\n");
		return -1;
	} else {
		delay_time = APP_WDT_TICK_DELAY;
		printf("Use default tick time interval for %d sec.\n", delay_time);
	}

	/* simple tick MCU uart port */
	do {
		mx_send_app_wdt_tick();
		sleep(delay_time);
	} while (1);

	return 0;
}

int main(int argc, char *argv[])
{
	int c;
	struct option long_options[] = {
		{"help", no_argument, 0, 'h'},
		{"time_interval", no_argument, 0, 't'},
		{0, 0, 0, 0}
	};

	if (argc > 3) {
		usage();
		return 1;
	}

	c = getopt_long(argc, argv, "ht", long_options, NULL);
	switch (c) {
		case 'h':
			usage();
			exit(0);
		case 't':
			if (argv[optind]) {
				run_tick_deamon(atoi(argv[optind]));
			}
		default:
			run_tick_deamon(0);
	}

	return 0;
}



