#!/bin/bash
#
# Copyright (C) 2023 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2023  Wilson YS Huang  <wilsonys.huang@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

REPO_NAME="moxa-it87-serial-driver"

main() {
        local src_ver
        src_ver="$2"

        log::info "Uninstall ${REPO_NAME} ($src_ver)"

        if util::is_exists "/lib/modules/$(uname -r)/kernel/drivers/misc/it87_serial.ko"; then
                log::debug "Remove it87_serial.ko"
                rm -f "/lib/modules/$(uname -r)/kernel/drivers/misc/it87_serial.ko"
        fi

        if util::is_exists "/usr/lib/modules-load.d/it87_serial.conf"; then
                log::debug "Remove it87_serial.conf"
                rm -f "/usr/lib/modules-load.d/it87_serial.conf"
        fi

        if util::is_exists "/usr/lib/modprobe.d/it87-serial-force-id-it8786.conf"; then
                log::debug "Remove it87-serial-force-id-it8786.conf"
                rm -f "/usr/lib/modprobe.d/it87-serial-force-id-it8786.conf"
        fi
}

main "$@"
