#!/bin/bash
#
# Copyright (C) 2023 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2023  Wilson YS Huang  <wilsonys.huang@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

main() {
        local mcu_ver

        if util::is_exists "/sbin/mx-scaler-util"; then
                mcu_ver=$(/sbin/mx-scaler-util -v 2>/dev/null | awk -F ":" '{print $2}')

                if ! util::is_empty_str "$mcu_ver"; then
                        log::info "$(printf " %-30s$(colors::green %-15s)%-15s%-25s\n" "- mx-scaler-util" "Yes" "N/A" "MCU FW:${mcu_ver}")"
                else
                        log::info "$(printf " %-30s$(colors::green %-15s)%-15s%-25s\n" "- mx-scaler-util" "Yes" "N/A" "MCU FW: unknown")"
                fi
        else
                log::info "$(printf " %-30s$(colors::red %-15s)%-15s%-25s\n" "- mx-scaler-util" "No" "N/A" "N/A")"
        fi

        if util::is_exists "/usr/sbin/mx-scalerd"; then
                if systemctl is-active mx-scalerd >/dev/null 2>&1; then
                        log::info "$(printf " %-30s$(colors::green %-15s)$(colors::green %-25s)\n" "- mx-scalerd" "Yes" "Active")"
                else
                        log::info "$(printf " %-30s$(colors::green %-15s)$(colors::red %-25s)\n" "- mx-scalerd" "Yes" "Inactive")"
                fi
        else
                log::info "$(printf " %-30s$(colors::red %-15s)%-15s%-25s\n" "- mx-scalerd (service)" "No" "N/A" "N/A")"
        fi
}

main "$@"
