#!/bin/bash
#
# Copyright (C) 2023 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2023  Wilson YS Huang  <wilsonys.huang@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

main() {
        if util::is_exists "/sbin/mx-lpc-mcu-upgrade-tool"; then
                log::info "$(printf " %-30s$(colors::green %-15s)%-15s%-25s\n" "- mx-lpc-mcu-upgrade-tool" "Yes" "N/A" "N/A")"
        else
                log::info "$(printf " %-30s$(colors::red %-15s)%-15s%-25s\n" "- mx-lpc-mcu-upgrade-tool" "No" "N/A" "N/A")"
        fi
}

main "$@"
