#!/bin/bash
#
# Copyright (C) 2024 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2024  Elvis Yao  <elviscw.yao@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

main() {
        if util::is_exists "/sbin/mx-app-wdt-ctl"; then
                log::info "$(printf " %-30s$(colors::green %-15s)%-15s%-25s\n" "- mx-app-wdt-ctl" "Yes" "N/A" "N/A")"
        else
                log::info "$(printf " %-30s$(colors::red %-15s)%-15s%-25s\n" "- mx-app-wdt-ctl" "No" "N/A" "N/A")"
        fi
}

main "$@"
