#!/bin/bash
#
# Copyright (C) 2024 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2024  Wilson YS Huang  <wilsonys.huang@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

REPO_NAME="moxa-mxu11x0-driver"
SRC_PATH_PREFIX="${INSTL_TOP_DIR}/src/${REPO_NAME}"

main() {
        local src_tag
        local src_ver
        src_tag="$1"
        src_ver="$2"

        log::info "Installing ${REPO_NAME} (${src_ver})"

        # RedHat/CentOS will load mxu11x0.ko.xz first after driver install.
        if [[ "${LINUX_DISTRO_ID}" == "rhel" ]] || [[ "${LINUX_DISTRO_ID}" == "centos" ]]; then
                local drv_path
                drv_path=$(modinfo -n mxu11x0 2>/dev/null || true)
                if [[ "${drv_path##*/}" == "mxu11x0.ko.xz" ]]; then
                        rm -f "${drv_path}"
                fi
        fi

        {
                pushd "${SRC_PATH_PREFIX}-${src_tag}" >/dev/null

                [[ ! -x mxinstall ]] && chmod +x mxinstall
                [[ ! -x driver/mxconf ]] && chmod +x driver/mxconf
                ./mxinstall

                popd
        } >>"${INSTL_LOG_FILE}" 2>&1

        log::info " Installing setserial tool"

        {
                case "${OS_PACKAGE_MANAGER}" in
                "apt")
                        apt-get update
                        apt-get install setserial -y
                        ;;
                "yum")
                        yum makecache
                        yum install setserial -y
                        ;;
                esac
        } >>"${INSTL_LOG_FILE}" 2>&1
}

main "$@"
