#!/bin/bash
#
# Copyright (C) 2023 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2023  Elvis Yao  <ElvisCW.Yao@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

REPO_NAME="moxa-it87-driver"
SRC_PATH_PREFIX="${INSTL_TOP_DIR}/src/${REPO_NAME}"

main() {
        local src_tag
        local src_ver
        src_tag="$1"
        src_ver="$2"

        log::info "Installing ${REPO_NAME} (${src_ver})"

        if [[ "${LINUX_DISTRO_ID}" == "rhel" ]] || [[ "${LINUX_DISTRO_ID}" == "centos" ]]; then
                local drv_path
                drv_path=$(modinfo -n it87 2>/dev/null || true)
                if [[ "${drv_path##*/}" == "it87.ko.xz" ]]; then
                        rm -f "${drv_path}"
                fi
        fi

        {
                pushd "${SRC_PATH_PREFIX}-${src_tag}" >/dev/null

                make clean
                make
                make install

                popd
        } >>"${INSTL_LOG_FILE}" 2>&1
}

main "$@"
