/* 	Copyright (C) MOXA Inc. All rights reserved.

   	This is free software distributed under the terms of the
   	GNU Public License. See the file COPYING-GPL for details.
*/

#ifndef _MXSIO_H
#define _MXSIO_H


#define SIO_MAX_UART			4
#define SIO_MAX_PORTS			32	

#define MXSIO				0x400
#define MXSIO_GETSTATUS                 (MXSIO + 65)
#define MXSIO_SET_OP_MODE		(MXSIO + 66)
#define MXSIO_GET_OP_MODE		(MXSIO + 67)
#define MXSIO_GETICOUNTER            	(MXSIO + 68)
#define MXSIO_RSTICOUNTER            	(MXSIO + 69)
#define MXSIO_ASPP_OQUEUE               (MXSIO + 70)
#define MXSIO_SETBAUD			(MXSIO + 71)
#define MXSIO_GETBAUD            	(MXSIO + 72)
#define MXSIO_MON                	(MXSIO + 73)
#define MXSIO_LSTATUS                   (MXSIO + 74)
#define MXSIO_MON_EXT                   (MXSIO + 75)
#define MXSIO_SET_BAUD_METHOD           (MXSIO + 76)
#define MXSIO_GET_WRITEROOM             (MXSIO + 77)
#define MXSIO_SET_FIFO                  (MXSIO + 80)
#define MXSIO_SET_RTS_TOGGLE            (MXSIO + 81)
#define MXSIO_SET_COLLISION_AVOIDANCE   (MXSIO + 82)
#define MXSIO_SET_DTRDSR_FLOW   	(MXSIO + 83)
#define MXSIO_SET_RESISTOR		(MXSIO + 84)
#define MXSIO_GET_RESISTOR		(MXSIO + 85)
#define MXSIO_SET_MODEM_CLOSE_STATE	(MXSIO + 86)
#define MXSIO_GET_MODEM_CLOSE_STATE	(MXSIO + 87)
#define MXSIO_SET_SPECIAL_BAUD_RATE     (MXSIO + 100)
#define MXSIO_GET_SPECIAL_BAUD_RATE     (MXSIO + 101)
#define MXSIO_SET_FIFO_MU150            (MXSIO + 102)
#define MXSIO_ACT_XON_MU150             (MXSIO + 103)
#define MXSIO_ACT_XOFF_MU150            (MXSIO + 104)
#define MXSIO_MON_EXT_2                 (MXSIO + 150)

//#define MXSIO_SET_SPECIAL_BAUD_RATE     	(MXSIO + 0x64)
//#define MXSIO_GET_SPECIAL_BAUD_RATE     	(MXSIO + 0x65)

#define NPPI_NOTIFY_CTSHOLD	0x01	/* TX hold by CTS low */
#define NPPI_NOTIFY_DSRHOLD	0x02	/* TX hold by DSR low */
#define NPPI_NOTIFY_XOFFHOLD	0x08	/* TX hold by Xoff received */
#define NPPI_NOTIFY_XOFFSENT	0x10	/* Xoff sent */

#define MX_ERR_BREAK		0x10
#define MX_ERR_OVERFLOW		0x08
#define MX_ERR_OVERRUN		0x04
#define MX_ERR_FRAME		0x02
#define MX_ERR_PARITY		0x01

#define UNSET 			-1

#define MODE_232        	0
#define MODE_422		1
#define MODE_4852W		2
#define MODE_4854W		3
	
#define SIO_M_CTS		0x10
#define SIO_M_DSR		0x20
#define SIO_M_RI		0x40
#define SIO_M_DCD		0x80


struct modem_close_state
{
	int is_enable;
	int dtr;
	int rts;	
};


struct mxser_serial
{
	int8_t uart_mode;	/* serial interface */
	int8_t termination_en; 	/* for RS485-2W */
	int8_t pull_hl_en;	/* for RS485-2W */
};


struct port_status
{
    int32_t 	port;
    uint32_t 	mmio;
    int32_t 	irq;
    uint32_t 	total_tx;
    uint32_t 	total_rx;
    uint32_t 	tx;
    uint32_t 	rx;
    uint32_t 	fr;
    uint32_t    pr;
    uint32_t 	or;
    uint32_t    br;
    uint32_t    ospeed;
    uint32_t 	ispeed;
    uint32_t    c_flag;
    uint32_t    i_flag;
    int32_t  	fifo;
    int32_t 	DSR;
    int32_t 	DTR;
    int32_t 	RTS;							
    int32_t 	CTS;
    int32_t 	DCD;
};								    
typedef struct port_status PORT_STATUS;						
typedef struct port_status *PORT_STATUS_P;

struct __port_status_ext 
{
	union {	
		uint32_t irq;
		uint32_t portno;
	} _config;

	uint32_t  	c_flag;
	uint32_t  	i_flag;
	uint32_t 	mmio;
	int32_t 	frame_error_cnt;
	int32_t 	parity_error_cnt;
	int32_t 	overrun_error_cnt;
	int32_t 	break_cnt;
	int32_t 	rts;
	int32_t 	dtr;
};
typedef struct __port_status_ext _port_status_ext;
typedef struct __port_status_ext *_port_status_ext_p;


struct mxser_mon
{
	unsigned long txcnt;
	unsigned long rxcnt;
	unsigned long up_rxcnt;
	unsigned long up_txcnt;
	int	 modem_status;
	unsigned char  hold_reason;
};

struct mxser_mon_ext 
{
	uint32_t rx_cnt[SIO_MAX_PORTS];
	uint32_t tx_cnt[SIO_MAX_PORTS];
	uint32_t up_rxcnt[SIO_MAX_PORTS];
	uint32_t up_txcnt[SIO_MAX_PORTS];
	int32_t modem_status[SIO_MAX_PORTS];

	uint32_t baudrate[SIO_MAX_PORTS];
	int32_t databits[SIO_MAX_PORTS];
	int32_t stopbits[SIO_MAX_PORTS];
	int32_t parity[SIO_MAX_PORTS];
	int32_t flowctrl[SIO_MAX_PORTS];
	int32_t fifo[SIO_MAX_PORTS];
	int32_t iftype[SIO_MAX_PORTS];
};

struct sio_data
{
	uint32_t  iftype;
	uint32_t  charmode;
	uint32_t  flowctrl;
	uint32_t  lstatus;
	uint32_t  baudrate;
	uint32_t  tx_cnt;
	uint32_t  rx_cnt;
	uint32_t  up_txcnt;
	uint32_t  up_rxcnt;
	uint32_t  fifo;
};
typedef struct sio_data SIODATA;

#endif

