/*
Copyright (C) MOXA Inc. All rights reserved.

This software is distributed under the terms of the
MOXA License.  See the file COPYING-MOXA for details.
*/
#include <iostream>
#include <windows.h>
#include<stdio.h>
#include<stdlib.h>
#include<getopt.h>  
#pragma comment(lib,"getopt.lib") 
#include "mxled.h"
using namespace std;

#define UNSET 	-1

enum action_type {
	GET_MODE = 0,
	SET_MODE = 1
};

struct action_struct {
	int type;
	int port;
	int mode;
};

void usage(FILE *fp)
{
	fprintf(fp, "Usage:\n");
	fprintf(fp, "	mx-led-ctl -i <led_index>  [-m <status>]\n");
	fprintf(fp, "OPTIONS:\n");
	fprintf(fp, "	-i <#led_index>\n");
	fprintf(fp, "		Set led index: [0..] \n");
	fprintf(fp, "	-m <#status>\n");
	fprintf(fp, "		Set mode for led index\n");
	fprintf(fp, "		0 --> led off\n");
	fprintf(fp, "		1 --> led on\n");
	fprintf(fp, "		2 --> led blink\n");
	fprintf(fp, "\n");
	fprintf(fp, "Example:\n");
	fprintf(fp, "	Turn on led INDEX 3\n");
	fprintf(fp, "	# mx-led-ctl -i 3 -m 1\n");
	fprintf(fp, "\n");
}

int my_atoi(const char *nptr, int *number)
{
	int tmp;

	tmp = atoi(nptr);
	if (tmp != 0) {
		*number = tmp;
		return 0;
	}
	else {
		if (!strcmp(nptr, "0")) {
			*number = 0;
			return 0;
		}
	}
	return -1;
}

void do_action(struct action_struct action)
{
	switch (action.type) {
	case GET_MODE:
		action.mode = GetLedData(action.port);
		if (action.mode < 0) {
			fprintf(stderr, "Failed to get Led index\n");
			exit(1);
		}
		printf("Led index %d status: %d\n", action.port, action.mode);
		break;
	case SET_MODE:
		if(SetLedData(action.port, action.mode) < 0)
		printf("Set OK.\n");
		break;
	}
}

int main(int argc, char**argv)
{
	struct action_struct action = { GET_MODE, UNSET, UNSET };
	int c;

	while (1) {
		c = getopt(argc, argv, "hi:m:");
		if (c == -1)
			break;

		switch (c) {
		case 'h':
			usage(stdout);
			exit(0);
		case 'i':
			if (my_atoi(optarg, &action.port) != 0) {
				fprintf(stderr, "%s is not a number\n", optarg);
				exit(1);
			}
			break;
		case 'm':
			action.type = SET_MODE;
			if (my_atoi(optarg, &action.mode) != 0) {
				fprintf(stderr, "%s is not a number\n", optarg);
				exit(1);
			}
			break;
		default:
			usage(stderr);
			exit(99);
		}
	}

	if (optind < argc) {
		fprintf(stderr, "non-option arguments found: ");
		while (optind < argc)
			fprintf(stderr, "%s ", argv[optind++]);
		fprintf(stderr, "\n");

		usage(stderr);
		exit(99);
	}

	if (action.port == UNSET) {
		fprintf(stderr, "port number is unset\n");
		usage(stderr);
		exit(99);
	}

	do_action(action);
	exit(0);
}