/*
	Copyright (C) MOXA Inc. All rights reserved.

	This software is distributed under the terms of the
	MOXA License.  See the file COPYING-MOXA for details.
*/
#pragma once
#include <iostream>
#include <string>
using namespace std;

#ifdef __cplusplus    // If used by C++ code, 
extern "C" {          // we need to export the C interface
#endif
	enum UART_STATUS
	{
		LIB_INITIALIZE_FAIL = -1,
		PORT_OUTOF_INDEX = -2,
		SET_STATUS_ERR = -3,
		NOT_SUPPORT_MODE = -4
	};

	HMODULE GetCurrentModule();
	HANDLE mxsp_open();
	void mxsp_close(HANDLE fd);
	int mxsp_get_interface(HANDLE fd, int port_index);
	int mxsp_set_interface(HANDLE fd, int port_index, int port_interface);

	int InitMXSP(void);
	int GetUartMode(int port);
	int SetUartMode(int port, int mode);

#ifdef __cplusplus    // If used by C++ code, 
}
#endif