﻿using CommandLine;
using CommandLine.Text;
using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;

namespace mx_dio_ctl
{
    class Program
    {
        class Options
        {
            [Option('i', Default = null, HelpText = "-i <#DIN index> (Start from 0)")]
            public uint? DIN { get; set; }

            [Option('o', Default = null, HelpText = "-o <#DOUT index> (Start from 0)")]
            public uint? DOUT { get; set; }

            [Option('m', Default = null,
                HelpText = "-m <status>\n" +
                " 		0 --> LOW\n" +
                "		1 --> HIGH"
                )]
            public uint? Mode { get; set; }

            [Usage(ApplicationAlias = "mx-dio-ctl")]
            public static IEnumerable<Example> Examples
            {
                get
                {
                    yield return new Example("Get value from DIN port 1", new Options { DIN = 1 });
                    yield return new Example("Get value from DOUT port 1", new Options { DOUT = 1 });
                    yield return new Example("Set DOUT port 2 value to HIGH", new Options { DOUT = 2, Mode = 1 });
                }
            }
        }

        [DllImport("mxdgio.dll", EntryPoint = "SetDoutStatus", CharSet = CharSet.Ansi, SetLastError = true)]
        public static extern int SetDoutStatus(int port, int mode);

        [DllImport("mxdgio.dll", EntryPoint = "GetDinStatus", CharSet = CharSet.Ansi, SetLastError = true)]
        public static extern int GetDinStatus(int port);

        [DllImport("mxdgio.dll", EntryPoint = "GetDoutStatus", CharSet = CharSet.Ansi, SetLastError = true)]
        public static extern int GetDoutStatus(int port);

        public struct Action_Struct
        {
            public int diport;
            public int doport;
            public int mode;
        };

        static void Main(string[] args)
        {
            CommandLine.Parser.Default.ParseArguments<Options>(args)
                .WithParsed(opts =>
                {
                    if (opts.Mode == null)
                    {
                        GetModeAction(opts);
                    }
                    else
                    {
                        SetModeAction(opts);
                    }
                });
        }

        private static void SetModeAction(Options opts)
        {
            Action_Struct action;
            action.doport = (int)opts.DOUT;
            if (SetDoutStatus(action.doport, (int)opts.Mode) < 0)
            {
                Console.WriteLine("Failed to set DOUT port {0} value.", action.doport);
            }
            else
            {
                action.mode = GetDoutStatus(action.doport);
                if (action.mode >= 0)
                {
                    Console.WriteLine("DOUT port {0} status: {1}", action.doport, action.mode);
                }
            }
        }

        private static void GetModeAction(Options opts)
        {
            Action_Struct action;
            if (opts.DIN != null)
            {
                action.diport = (int)opts.DIN;
                action.mode = GetDinStatus(action.diport);
                if (action.mode>=0)
                {
                    Console.WriteLine(string.Format("DIN port {0} status: {1}", action.diport, action.mode));
                }
            }
            if (opts.DOUT != null)
            {
                action.doport = (int)opts.DOUT;
                action.mode = GetDoutStatus(action.doport);
                if (action.mode >= 0)
                {
                    Console.WriteLine(string.Format("DOUT port {0} status: {1}", action.doport, action.mode));
                }
            }
        }
    }
}
