#!/bin/ksh

# Set up serial card with multiple ports

# echo "devid :" $1  
# echo "count :" $2
# echo "irq :" $3
# echo "port :" $4
# echo "inc :" $5
# echo "command :" $6
# echo

# set -x

# vender = PCI Vender ID
integer devid=$1

# Count = number of ports on this card
integer count=$2
# irq = the relevant IRQ for the card $(irq)
integer irq=$3
# port = port address of the first port on the card $(ioport1)
typeset -i10 port=16#$4
# distance = distance between each port
integer distance=$5

shift 5

# Seed the command with the rest of the parameters
export command=$*

# Add another port to the command
while [ count -gt 0 ]
do
command="$command $(printf "%x,%u" $port $irq )"
#echo "count $count port $port command $command"
let port=$port+$distance
let count=$count-1

if [ devid -eq 1144 ] || [ devid -eq 1045 ] ; then
    if [ count -eq 1 ]; then
	let port=$port+4*$distance
    fi
fi

done

if [ devid -eq 1182 ]; then
	for dev in $(/usr/sbin/mxconf -l | grep dev[0-3] | cut -f1); do
		/usr/sbin/mxconf -r off $dev
	done
fi

# Do it !
$command &

return 
