﻿using CommandLine;
using CommandLine.Text;
using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;

namespace mx_m2bpower_ctl
{
    class Program
    {
        class Options
        {
            [Option('i', Required = true, HelpText = "-i <#M2B Slot index> (Start from 0)")]
            public uint M2BSlotIndex { get; set; }

            [Option('m', Default = null,
                HelpText = "-m <M2B power status>\n" +
                "0 --> M2B power off\n" +
                "1 --> M2B power on\n"
                )]
            public int? M2BStatus { get; set; }

            [Usage(ApplicationAlias = "mx-m2bpower-ctl")]
            public static IEnumerable<Example> Examples
            {
                get
                {
                    yield return new Example("Get m2b power status from m2b slot 1", new Options { M2BSlotIndex = 1 });
                    yield return new Example("Set m2b slot 1 power on", new Options { M2BSlotIndex = 1, M2BStatus = 1 });
                }
            }
        }

        [DllImport("mxm2bpower.dll", EntryPoint = "GetPowerStatus", CharSet = CharSet.Ansi, SetLastError = true)]
        public static extern int GetM2BSlotStatus(int port);


        [DllImport("mxm2bpower.dll", EntryPoint = "SetPowerStatus", CharSet = CharSet.Ansi, SetLastError = true)]
        public static extern int SetM2BSlotStatus(int port, int mode);

        public struct Action_Struct
        {
            public int index;
            public int number;
        };

        static void Main(string[] args)
        {
            CommandLine.Parser.Default.ParseArguments<Options>(args)
                .WithParsed(opts =>
                {
                    if (opts.M2BStatus == null)
                    {
                        GetModeAction(opts);
                    }
                    else
                    {
                        SetModeAction(opts);
                    }
                });
        }

        private static void SetModeAction(Options opts)
        {
            Action_Struct action;
            action.index = (int)opts.M2BSlotIndex;

            if (SetM2BSlotStatus(action.index, (int)opts.M2BStatus) < 0)
            {
                Console.WriteLine("Failed to set M2B slot {0} power status.", action.index);
            }
            else
            {
                action.number = GetM2BSlotStatus(action.index);
                if (action.number >= 0)
                {
                    Console.WriteLine("M2B slot {0} power status: {1}", action.index, action.number);
                }
            }

        }

        private static void GetModeAction(Options opts)
        {
            Action_Struct action;
            action.index = (int)opts.M2BSlotIndex;
            action.number = GetM2BSlotStatus(action.index);
            if (action.number >= 0)
            {
                Console.WriteLine(string.Format("M2B slot {0} power status: {1}", action.index, action.number));
            }
        }
    }
}
