#ifndef _NECI_H
#define _NECI_H


#if !(defined(_WINSOCKAPI_) || defined(_WINSOCKAPI2_))
#include <winsock2.h>
#endif

#define NECI_VERSION	1


/* define HWID */
#define	NE4000T			0x4000

#define NE4110S			0x4119
#define NE4120S			0x4129
#define NE4100T			0x4109
#define NE4110A			0x4118
#define NE4120A			0x4128

#define NE4110SP		0xC119
#define NE4120SP		0xC129
#define NE4100TP		0xC109
#define NE4110AP		0xC118
#define NE4120AP		0xC128

#define NP4511P			0x4511

#define NP5210P			0x4512
#define NP5230P			0x4513

#define NP5410P			0x4514
#define NP5430P			0x4515

#define WE2100T_US		0x2100
#define WE2100T_EU		0x2101
#define WE2100T_JP		0x2102


/* error code */
#define DSC_OK			1
#define DSC_FAIL		-1
#define DSC_TOUT		-2
#define DSC_SOCKET		-3
#define DSC_USER_BREAK		-4
#define	DSC_PARAM		-5
#define DSC_FOPEN_FAIL		-6
#define	DSC_FLASH_LEN		-7
#define	DSC_FIRM_FORMAT		-9
#define DSC_MAX_LIMIT		-10
#define DSC_MEM_ALLOC		-11
#define DSC_NOT_LOGIN		-12

#define DS_HANDLE		int
#define IPLHANDLE		SOCKET


/* dsc_GetKernelInfo */
/*	KERNELINFO.flag */
#define K_PASSENABLED	0x01

/* dsc_GetSerialIOCtl */
#define B50		0x00
#define B75		0x01
#define B110		0x02
#define B134		0x03
#define B150		0x04
#define B300		0x05
#define B600		0x06
#define B1200		0x07
#define B1800		0x08
#define B2400		0x09
#define B4800		0x0A
#define B7200		0x0B
#define B9600		0x0C
#define B19200		0x0D
#define B38400		0x0E
#define B57600		0x0F
#define B115200 	0x10
#define B230400 	0x11

#define BIT_5	0x00
#define BIT_6	0x01
#define BIT_7	0x02
#define BIT_8	0x03

#define STOP_1	0x00
#define STOP_2	0x04

#define P_NONE		0x00
#define P_ODD		0x08
#define P_EVEN		0x18
#define P_MRK		0x28
#define P_SPC		0x38

#define NONE_FLOWCTRL	0
#define HW_FLOWCTRL	1
#define SW_FLOWCTRL	2
#define DTRDSR_FLOWCTRL	3

/*	dsc_GetSerialInterface */
#define IF_RS232	0
#define IF_RS422	1
#define IF_RS4852W	2
#define IF_RS4854W	3

/*      dsc_GetSerialLineStatus */
#define L_RTS	0x02
#define L_DTR	0x01
#define L_CTS	0x10
#define L_DSR	0x20
#define L_DCD	0x80

/* dsc_UpgradeXXX step define */
#define DW_CONNECT      10
#define DW_SEND_DATA    20
#define DW_UPDATE       30
#define DW_WAIT_FINISH  40

/* dsc_GetSerialIOCtl, dsc_GetSerialFIFO, dsc_GetSerialInterface */
#define SERCURRENT      0
#define SERINIT         1

/* dsc_GetNetstat, TCP state */
#define ST_CLOSED       0
#define ST_LISTEN       1
#define ST_SYN_RCVD     2
#define ST_SYN_SEND     3
#define ST_ESTABLISHED  4
#define ST_FIN_WAIT1    5
#define ST_FIN_WAIT2    6
#define ST_CLOSE_WAIT   7
#define ST_CLOSING      8
#define ST_LAST_ACK     9
#define ST_TIME_WAIT    10


/* DS_INFO.flag */
#define IP_SPECIFIED	0x01

/* set console */
#define CON_WEB		0x01
#define CON_TELNET	0x02
#define CON_SERIAL	0x04	//alan //hank
#define CON_SWRESET	0x08
#define CON_HTTPS	0x10
#define CON_SSH	0x20

/* set serial command mode */


/* log event teyp */
#define	EVT_COLD_START	1
#define EVT_WARM_START	2
#define EVT_ATUEH_FAIL	3
#define EVT_IP_CHANGED	4
#define	EVT_PASS_CHANGED	5
#define EVT_DCD_OFF	6
#define EVT_DCD_ON	7
#define EVT_DSR_OFF	8
#define EVT_DSR_ON	9  

/* opmode */
#define	DRV_MODE	0x02
#define RFC2217_MODE	0x14
#define TCPSVR_MODE	0x0A
#define TCPCLI_MODE	0x0D
#define UDP_MODE	0x0E

/* WNDLIBPROC func define */
#define FUNC_GET_SEARCH	                0x01
#define	FUNC_GET_LOCATE	                0x02
#define FUNC_GET_NAME	                0x10
#define FUNC_GET_WATCHDOG	        0x12
#define FUNC_GET_DEBUG		        0x13
#define FUNC_GET_NETSTAT		0x14
#define FUNC_GET_APINFO		        0x15
#define FUNC_GET_KERNELINFO	        0x16
#define FUNC_GET_APSTATUS		0x17
#define FUNC_GET_ENVIRONMENTMODE	0x18
#define FUNC_GET_IP			0x21
#define FUNC_GET_NETMASK		0x22
#define FUNC_GET_GATEWAY		0x23
#define FUNC_GET_IPCONFIG	        0x24
#define FUNC_GET_IPLOCATION	        0x25
#define FUNC_GET_IFCONFIG	        0x26

#define FUNC_GET_SERIALIOCTL	        0x31
#define FUNC_GET_SERIALFIFO	        0x32
#define FUNC_GET_SERIALINTERFACE	0x34
#define FUNC_GET_SERIALLINESTATUS	0x35
#define FUNC_GET_SERIALDATACNT	        0x36
#define FUNC_GET_DIOMAX			0x61
#define FUNC_GET_DIOMODE                0x62 //alan
#define FUNC_GET_DIOSTATE               0x63 //alan
#define FUNC_GET_DIOPORT               0x66 //alan

#define FUNC_SET_BIT                 0x80000000L

#define	FUNC_SET_GETID	                (0x00 | FUNC_SET_BIT)
#define FUNC_SET_LOGIN	                (0x01 | FUNC_SET_BIT)
#define FUNC_SET_SAVERESTART	        (0x02 | FUNC_SET_BIT)
#define FUNC_RECV_CONFIG		(0x03 | FUNC_SET_BIT)
#define FUNC_UPGRADE_CONFIG		(0x04 | FUNC_SET_BIT)
#define FUNC_UPGRADE_FIRM		(0x05 | FUNC_SET_BIT)
#define FUNC_UPGRADE_FIRM_FILE          (0x06 | FUNC_SET_BIT)
#define FUNC_UPGRADE_FIRM_AP		(0x08 | FUNC_SET_BIT)

#define FUNC_SET_RUNORSTOPAP	        (0x09 | FUNC_SET_BIT)
#define FUNC_SET_PRIVATEKEY	        (0x0A | FUNC_SET_BIT)

#define FUNC_SET_NAME		        (0x10 | FUNC_SET_BIT)
#define FUNC_SET_PASSWORD	        (0x11 | FUNC_SET_BIT)
#define FUNC_SET_WATCHDOG	        (0x12 | FUNC_SET_BIT)
#define FUNC_SET_DEBUG		        (0x13 | FUNC_SET_BIT)

#define FUNC_SET_IP			(0x21 | FUNC_SET_BIT)
#define FUNC_SET_NETMASK		(0x22 | FUNC_SET_BIT)
#define FUNC_SET_GATEWAY		(0x23 | FUNC_SET_BIT)
#define FUNC_SET_IPCONFIG	        (0x24 | FUNC_SET_BIT)
#define FUNC_SET_IPLOCATION	        (0x25 | FUNC_SET_BIT)

#define FUNC_SET_SERIALIOCTL	        (0x31 | FUNC_SET_BIT)
#define FUNC_SET_SERIALFIFO	        (0x32 | FUNC_SET_BIT)
#define FUNC_SET_SERIALINTERFACE	(0x34 | FUNC_SET_BIT)
#define FUNC_SET_DIOPORT		(0x66 | FUNC_SET_BIT)


/***************************************************/
//#ifndef	_BASE_DEFINE
//#define _BASE_DEFINE

#define MAXDS		512     /* Max Device Server number supported */
#define MACLEN		6       /* MAC Address field byte count */
#define	APNAMELEN	40      /* AP name max length */
#define HOSTNAMELEN	40      /* Host Domain Name max length */
#define SVRNAMELEN      40      /* Device Server Name */
#define MAXIFITEM	256      /* dsc_GetIfConfig item max count */
#define SVRPASSWDLEN	16      /* password max length */
#define USRNAMELEN	16
#define PRIVATEKEYLEN	15      /* private key max length */
#define	MAXNETITEM	256     /* dsc_GetNetStat item max count */
#define MAILADDRLEN	64
#define PORTNAMELEN	16
#define MAXLOGCNT	1024
#define FSNAME          32

#define MAXMULTISESSION	4
#define MAXMULTISESSION3G	8	// For 3G server mode

#define MAXPORT         16
#define MAXACCESSIP	16
#define MAXDIO          4  //alan

#define MAXUSER			16

#define PPPNAMELEN		20
#define PPPPASSWORDLEN		20
#define	PPPDIALOUTLEN		52
#define	MODEMSTRLEN		52
#define BANKSIZE		32768
	
typedef struct _DS_INFO{
	DWORD	apid;
	WORD	hwid;
	WORD	flag;
	DWORD	real_ip_addr;
	DWORD	pseudo_ip_addr;
	DWORD	host_ip_addr;
	BYTE	mac[MACLEN];
}DS_INFO, *PDS_INFO;

typedef struct _NETSTATINFO{
	DWORD		remote_ip;
	DWORD		local_ip;
	WORD		remote_port;
	WORD		local_port;
	BYTE		socket_type;
	BYTE		connect_status;
	BYTE		ser_port;
	BYTE		reserve;
}NETSTATINFO, *PNETSTATINFO;

typedef struct _KERNELINFO{
	DWORD		firm_version;
	DWORD		bios_version;
	DWORD		serial_no;
	WORD		flag;
	WORD		SDKCI_Ver;
}KERNELINFO, *PKERNELINFO;

typedef struct _FSINFO{
    BYTE        havefs;
    BYTE        reserved[3];
    char        name[FSNAME];
    DWORD       ver;
    DWORD       time;
    DWORD       size;
}FSINFO, *PFSINFO;

typedef struct _IPLOCATIONINFO{
	char		loc_server[HOSTNAMELEN];
	WORD		loc_port;
	WORD		loc_period;
}IPLOCATIONINFO, *PIPLOCATIONINFO;

typedef struct _IFCONFIGINFO{
	WORD		ifid;
	WORD		flag;
	DWORD		ipaddr;
	DWORD		netmask;
	DWORD		gateway;
}IFCONFIGINFO, *PIFCONFIGINFO;

typedef struct	_SERPARMITEM{
	DWORD		baud;
	BYTE		mode;
	BYTE		flowctrl;
	BYTE		reserve[2];
}SERPARMITEM, *PSERPARMITEM;

typedef struct _SERDATACNT{
	DWORD		txcnt;
	DWORD		rxcnt;
	DWORD		total_txcnt;
	DWORD		total_rxcnt;
}SERDATACNT, *PSERDATACNT;

typedef struct _IPLOCATION_DATA{
	BYTE		name[SVRNAMELEN];
	DWORD		apid;
	WORD		hwid;
	BYTE		mac[MACLEN];
	DWORD		serialno;
	DWORD		ip;
	WORD		port;
	WORD		reserve;
}IPLOCATION_DATA, *PIPLOCATION_DATA;

/* NE Standard Version Only */
typedef struct _SNMPINFO{
	BYTE		is_enabled;
    BYTE		reserved[3];
	char		community[HOSTNAMELEN];
	char		contact[HOSTNAMELEN];
	char		location[HOSTNAMELEN];
	char		trap_host[HOSTNAMELEN];
}SNMPINFO, *PSNMPINFO;

#define MAILADDRLEN		64
typedef struct _MAILINFO{
	char mail_svr[HOSTNAMELEN];
    DWORD		auth_enable;
    char		from_addr[MAILADDRLEN];
    char		to_addr1[MAILADDRLEN];
    char		to_addr2[MAILADDRLEN];
    char		to_addr3[MAILADDRLEN];
    char		to_addr4[MAILADDRLEN];
}MAILINFO, *PMAILINFO;

typedef struct _DATAPACKINGINFO{
	BYTE		enabled;
	BYTE		ch1;
	BYTE		ch2;
	BYTE		reserved;
	DWORD		force_tx;
}DATAPACKINGINFO, *PDATAPACKINGINFO;

typedef struct _DRVMODEINFO{
	BYTE		max_connection;
}DRVMODEINFO, *PDRVMODEINFO;

typedef struct _TCPSVRINFO{
	WORD		cmd_port;
    WORD		listen_port;
	DWORD		max_connection;
}TCPSVRINFO, *PTCPSVRINFO;

typedef struct _TCPCLI_ITEM{
	char		dest_svr[MAXMULTISESSION][HOSTNAMELEN];
    WORD		dest_port[MAXMULTISESSION];
}TCPCLIITEM;

typedef struct _TCPCLIINFO{
	TCPCLIITEM	tcpcli_item;
    WORD		conn_mode;
    WORD		reserved;
}TCPCLIINFO, *PTCPCLIINFO;

typedef struct _UDP_ITEM{
	DWORD		ip[2];
    WORD		port;
}UDP_ITEM;

typedef struct _UDP_INFO{
    UDP_ITEM	udpitem[4];
    WORD		port;
}UDP_INFO, *PUDP_INFO;

typedef struct _ACCESSIPINFO{
    DWORD		mode;
	DWORD		ip_addr;
    DWORD		mask;
}ACCESSIPINFO, *PACCESSIPINFO;

typedef struct _ALERTINFO{
    WORD		event;
    WORD		mail;
    WORD		trap;
    WORD		reserved;
}ALERTINFO, *PALERTINFO;

typedef struct _PORTALERTINFO{
    BYTE		event;
    BYTE		mail;
    BYTE		trap;
    BYTE		reserved;
}PORTALERTINFO, *PPORTALERTINFO;

/* NE-4100-CMD Only */
typedef struct _SCMD_INFO{
        int     serial_command;
        int     scmd_special;
}SCMD_INFO;

/* Customer Version */
typedef struct	_PHY_MODE{
        BYTE	current;
        BYTE	last;
        BYTE	status;
        BYTE	reserved;        
}PHY_MODE;

typedef struct _PHY_INFO{
        BYTE		index;
        BYTE        interfaces;
        WORD		reserved;
        PHY_MODE	phy_mode[2];	
}PHY_INFO;

typedef struct _PHY_MODE_SET{
        BYTE        index;
        BYTE        mode;
}PHY_MODE_SET;

typedef struct _GRAARP_INFO{
        BYTE		lan;
        BYTE        enable;
        WORD		period;
}GRAARP_INFO;

typedef struct _GRAARP_INFO_SET{
        BYTE		lan;
        BYTE        enable;
        WORD		period;
}GRAARP_INFO_SET;


typedef struct _PPP_CONFIG{
	BYTE		opmode;
	BYTE		disconnectmode;
	BYTE		supportLQR;
	BYTE		authtype;
	char		myusername[PPPNAMELEN];
	char		mypassword[PPPPASSWORDLEN];
	DWORD		localip;
	DWORD		remoteip;
	DWORD		netmask;
	DWORD		baudrate;
	BYTE		datamode;
	BYTE		flowctrl;
	BYTE		reverse[2];
	char		dialoutcmd[PPPDIALOUTLEN];
	char		modeminitstr[MODEMSTRLEN];
} PPPCONFIG, *PPPPCONFIG;

typedef struct _PPP_STATUS{
	BYTE		pppstate;
	BYTE        reserved[3];
	DWORD		myip;
	DWORD		remoteip;
} PPPSTATUS, *PPPPSTATUS;

typedef struct _PPP_STATISTIC{
	DWORD		lasttimeconnect;
	DWORD		lasttimedisconnect;
	DWORD		sendbytes;
	DWORD		recvbytes;
} PPPSTATISTIC, *PPPPSTATISTIC;

typedef struct _PPP_AUTHTBL{
	char		remoteusername[MAXUSER][PPPNAMELEN];
	char		remotepassword[MAXUSER][PPPPASSWORDLEN];
} PPPAUTHTBL, *PPPPAUTHTBL;

/* Programmable Version */
typedef struct _APINFO{
	BYTE		name[APNAMELEN];
	DWORD		version;
	WORD		year;
	BYTE		month;
	BYTE		day;
	BYTE		hour;
	BYTE		min;
	WORD		reserve;
	DWORD		length;
}APINFO, *PAPINFO;

typedef struct _ROUTINGTABLE{
	DWORD		destip;
	DWORD		gateway;
	DWORD		netmask;
	BYTE		metric;
	BYTE		port;
	BYTE		type;
	BYTE		flags;
	DWORD		uses;
} ROUTINGTABLE, *PROUTINGTABLE;

typedef struct _BANK_INFO{
	BYTE		bank_number;
	BYTE		reserve1;
	BYTE		reserve2;
	BYTE		reserve3;
	DWORD		start_offset;
	DWORD		read_length;
} BANK_INFO, *PBANK_INFO;

typedef struct _BANK_DATA{
	DWORD		data_length;
	char 		data[BANKSIZE];
} BANK_DATA, *PBANK_DATA;

typedef struct _SET_BANK_INFO{
	DWORD		data_length;
	BYTE		bank_number;
	BYTE		mode;
	BYTE		reserve1;
	BYTE		reserve2;
} SET_BANK_INFO, *PSET_BANK_INFO;

/* 3G */
typedef struct _RFC2217CONFIG{
	WORD	tcp_port;
	BYTE	reserved[2];
}RFC2217CONFIG, *PRFC2217CONFIG;

typedef struct _ASYNCIOCTL{
	DWORD	baudrate;
	BYTE	mode;
	BYTE	flowctrl;
	BYTE	reserved[2];
}ASYNCIOCTL, *PASYNCIOCTL;

/* WE2100T only */
typedef struct _WLANPROFILE{
	char	profile_name[32];
	BYTE	enable;
	BYTE	opmode;
	WORD	channel;
	char	ssid[32];
}WLANPROFILE, *PWLANPROFILE;

typedef struct _WPAPARAMETER{
	BYTE	auth;
	BYTE	encrypt;
	BYTE	eap;
	BYTE	tunnel_auth;
	
	BYTE	valid_flag;	// Used for setting only
	BYTE	reserved1[3];
	
	BYTE	wep_key_len;
	BYTE	wep_key_idx;
	BYTE	reserved2[2];
	BYTE	wep_key[4][13];	// Used for setting only
	
	char	username[40];
	char	password[40];	// Used for setting only
	char	anony_user[40];
	BYTE	cert_flag;
	BYTE	reserved3[3];
	
	BYTE	psk_passphrase[64];	// Used for setting only
}WPAPARAMETER, *PWPAPARAMETER;

/* Reserve */
typedef struct _SYSLOG{
	WORD		year;
    BYTE		month;
    BYTE		day;
    BYTE		hour;
	BYTE		min;
    BYTE		sec;
    BYTE		type;
    WORD		Port;
    BYTE		reserved[54];
}SYSLOG, *PSYSLOG;

typedef int (CALLBACK* WNDENUMSEARCHPROC)(PDS_INFO);
typedef int (CALLBACK* WNDLIBPROC)(DWORD, int, int, LPVOID);

#ifdef __cplusplus
extern "C" {
#endif

#if defined(_BUILD_DLL) || defined(NE_EXPORTS)
#define IMPORT_EXPORT __declspec(dllexport)
#else
#define IMPORT_EXPORT __declspec(dllimport)
#endif

#define SDKCI_FUNC	__stdcall

/* Search & Attach */
IMPORT_EXPORT int SDKCI_FUNC dsc_EnumSearch(DWORD server_ip, WNDENUMSEARCHPROC lpenumproc);
IMPORT_EXPORT int SDKCI_FUNC dsc_Attach(PDS_INFO info, DS_HANDLE *dshandle);
IMPORT_EXPORT int SDKCI_FUNC dsc_Detach(DS_HANDLE dshandle);
IMPORT_EXPORT int SDKCI_FUNC dsc_Login(DS_HANDLE dshandle, char *password);
IMPORT_EXPORT int SDKCI_FUNC dsc_Logout(DS_HANDLE dshandle);

/* System Control */
IMPORT_EXPORT int SDKCI_FUNC dsc_GetKernelInfo(DS_HANDLE dshandle, PKERNELINFO info);
IMPORT_EXPORT int SDKCI_FUNC dsc_GetDSINFO(DS_HANDLE dshandle, PDS_INFO dsinfo);
	/* NE-4100 & NE-4100-CMD Only */
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetFsInfo(DS_HANDLE dshandle, PFSINFO fsinfo);
IMPORT_EXPORT int SDKCI_FUNC dsc_SetPassword(DS_HANDLE dshandle, char *password);
	/* NE-4100 & NE-4100-CMD Only */
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetIPFilter(DS_HANDLE dshandle, int idx, int *enable_filter, PACCESSIPINFO info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetIPFilter(DS_HANDLE dshandle, int enable_ipfilter, PACCESSIPINFO info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetConsole(DS_HANDLE dshandle, int *settings);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetConsole(DS_HANDLE dshandle, int settings);
IMPORT_EXPORT int SDKCI_FUNC dsc_GetName(DS_HANDLE dshandle, char *name);
IMPORT_EXPORT int SDKCI_FUNC dsc_SetName(DS_HANDLE dshandle, char *name);
IMPORT_EXPORT int SDKCI_FUNC dsc_Locate(DS_HANDLE dshandle, int sw);
IMPORT_EXPORT int SDKCI_FUNC dsc_SaveAndRestart(DS_HANDLE dshandle);
IMPORT_EXPORT int SDKCI_FUNC dsc_Restart(DS_HANDLE dshandle);
IMPORT_EXPORT int SDKCI_FUNC dsc_SetToFactoryDefault(DS_HANDLE dshandle);

	/* NE-4000T-RC Only */
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetModemSetting(DS_HANDLE dshandle, char * md_enable);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetModemSetting(DS_HANDLE dshandle, char md_enable);
	
	/* NE-4100-CMD Only */
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetCmdState(DS_HANDLE dshandle, SCMD_INFO * scmd_info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetCmdState(DS_HANDLE dshandle, SCMD_INFO * scmd_info);
	
	/* Customer Version Only */
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetPHYStatus(DS_HANDLE dshandle, BYTE index, PHY_INFO * phy_info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetPhyMode(DS_HANDLE dshandle, PHY_MODE_SET * phy_mode_set);

	IMPORT_EXPORT int SDKCI_FUNC dsc_GetGraArp(DS_HANDLE dshandle, BYTE index, GRAARP_INFO * gra_info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetGraArp(DS_HANDLE dshandle, GRAARP_INFO_SET * gra_arp_setting);

/* Application Control */
	/* NE-4100-P & NPort-P Only */
	IMPORT_EXPORT int SDKCI_FUNC dsc_ClearUserAP(DS_HANDLE dshandle);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetAPInfo(DS_HANDLE dshandle, PAPINFO info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetAPStatus(DS_HANDLE dshandle, int *status);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetEnvironmentMode(DS_HANDLE dshandle, int *mode);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetSDKDevFlag(DS_HANDLE dshandle, int mode);
	IMPORT_EXPORT int SDKCI_FUNC dsc_RunOrStopUserAp(DS_HANDLE dshandle, int setting);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetPrivateKey(DS_HANDLE dshandle, char *key);
	IMPORT_EXPORT int SDKCI_FUNC dsc_RecvAPConfig(DS_HANDLE dshandle, char *buf, DWORD len);
	IMPORT_EXPORT int SDKCI_FUNC dsc_UpgradeAPConfig(DS_HANDLE dshandle, char *buf, DWORD len);
	IMPORT_EXPORT int SDKCI_FUNC dsc_RecvAPConfig_Bank(DS_HANDLE dshandle, BANK_INFO bank_info, PBANK_DATA pbank_data);
	IMPORT_EXPORT int SDKCI_FUNC dsc_UpgradeAPConfig_Bank(DS_HANDLE dshandle, SET_BANK_INFO set_bank_info, char * bankdata);
	IMPORT_EXPORT int SDKCI_FUNC dsc_RecvAPConfigBank(DS_HANDLE dshandle, DWORD bank_number, DWORD start_offset, char * buffer, DWORD read_length);
	IMPORT_EXPORT int SDKCI_FUNC dsc_UpgradeAPConfigBank(DS_HANDLE dshandle, DWORD bank_number, char * bankdata, DWORD write_length);
	IMPORT_EXPORT int SDKCI_FUNC dsc_UpgradeAPConfig_NoErase(DS_HANDLE dshandle, char *buf, DWORD len);
	IMPORT_EXPORT int SDKCI_FUNC dsc_Erase_APConfig_Bank(DS_HANDLE dshandle, DWORD bank_number);
	IMPORT_EXPORT int SDKCI_FUNC dsc_UpdateDSINFO(DS_HANDLE dshandle, PDS_INFO dsinfo);
	
/* Time Control */
IMPORT_EXPORT int SDKCI_FUNC dsc_GetTime(DS_HANDLE dshandle, PSYSTEMTIME systm);
IMPORT_EXPORT int SDKCI_FUNC dsc_SetTime(DS_HANDLE dshandle, PSYSTEMTIME systm);
IMPORT_EXPORT int SDKCI_FUNC dsc_GetWinTime(DS_HANDLE dshandle, PSYSTEMTIME systm);
IMPORT_EXPORT int SDKCI_FUNC dsc_SetWinTime(DS_HANDLE dshandle, PSYSTEMTIME systm);
IMPORT_EXPORT int SDKCI_FUNC dsc_GetTimeServer(DS_HANDLE dshandle, char *tmsvr);
IMPORT_EXPORT int SDKCI_FUNC dsc_SetTimeServer(DS_HANDLE dshandle, char *tmsvr);
IMPORT_EXPORT int SDKCI_FUNC dsc_GetTimeZone(DS_HANDLE dshandle, LONG *time_zone, DWORD *time_zone_idx);
IMPORT_EXPORT int SDKCI_FUNC dsc_SetTimeZone(DS_HANDLE dshandle, LONG time_zone, DWORD time_zone_idx);
IMPORT_EXPORT int SDKCI_FUNC dsc_Get_TimeZone_Index(DS_HANDLE dshandle, DWORD * index);
IMPORT_EXPORT int SDKCI_FUNC dsc_Set_TimeZone_Index(DS_HANDLE dshandle, DWORD index);

/* OP Mode */
	/* NE-4100 & NE-4100-CMD Only */
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetOpMode(DS_HANDLE dshandle, int port, int *mode);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetOPMode(DS_HANDLE dshandle, int port, int mode);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetDataPacking(DS_HANDLE dshandle, int port, PDATAPACKINGINFO info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetDataPacking(DS_HANDLE dshandle, int port, PDATAPACKINGINFO info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetInactivityTime(DS_HANDLE dshandle, int port, WORD *inact_tm);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetInactivityTime(DS_HANDLE dshandle, int port, WORD inact_time);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetTCPAliveTime(DS_HANDLE dshandle, int port, WORD *alive_tm);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetTCPAlive(DS_HANDLE dshandle, int port, WORD alive_tm);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetDriverMode(DS_HANDLE dshandle, int port, PDRVMODEINFO info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetDriverMode(DS_HANDLE dshandle, int port, PDRVMODEINFO info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetTCPServerMode(DS_HANDLE dshandle, int port, PTCPSVRINFO info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetTCPSvrMode(DS_HANDLE dshandle, int port, PTCPSVRINFO info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetTCPClientMode(DS_HANDLE dshandle, int port, PTCPCLIINFO info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetTCPCliMode(DS_HANDLE dshandle, int port, PTCPCLIINFO info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetUDPMode(DS_HANDLE dshandle, int port, UDP_INFO info[MAXPORT]);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetUDPMode(DS_HANDLE dshandle, int port, PUDP_INFO info);

/* Network Config */
	/* NE-4100 & NE-4100-CMD Only */
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetSNMP(DS_HANDLE dshandle, PSNMPINFO snmpinfo);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetSNMP(DS_HANDLE dshandle, PSNMPINFO snmpinfo);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetDNS(DS_HANDLE dshandle, int ifid, DWORD *dns1, DWORD *dns2);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetDNS(DS_HANDLE dshandle, int ifid, DWORD dns1, DWORD dns2);

IMPORT_EXPORT int SDKCI_FUNC dsc_GetIP(DS_HANDLE dshandle, int ifid, DWORD *ip);
IMPORT_EXPORT int SDKCI_FUNC dsc_SetIP(DS_HANDLE dshandle, int ifid, DWORD newip);
IMPORT_EXPORT int SDKCI_FUNC dsc_GetNetmask(DS_HANDLE dshandle, int ifid, DWORD *netmask);
IMPORT_EXPORT int SDKCI_FUNC dsc_SetNetmask(DS_HANDLE dshandle, int ifid, DWORD netmask);
IMPORT_EXPORT int SDKCI_FUNC dsc_GetGateway(DS_HANDLE dshandle, int ifid, DWORD *gateway);
IMPORT_EXPORT int SDKCI_FUNC dsc_SetGateway(DS_HANDLE dshandle, int ifid, DWORD gateway);
IMPORT_EXPORT int SDKCI_FUNC dsc_GetIPConfig(DS_HANDLE dshandle, int ifid, int *setting);
IMPORT_EXPORT int SDKCI_FUNC dsc_SetIPConfig(DS_HANDLE dshandle, int ifid, int setting);
IMPORT_EXPORT int SDKCI_FUNC dsc_GetNetstat(DS_HANDLE dshandle, int maxsocket, int *retcnt, PNETSTATINFO info);
IMPORT_EXPORT int SDKCI_FUNC dsc_GetNetstat_ex(DS_HANDLE dshandle, int maxsocket, int *retcnt, PNETSTATINFO info);
IMPORT_EXPORT int SDKCI_FUNC dsc_GetIfConfig(DS_HANDLE dshandle, int maxif, int *retcnt, PIFCONFIGINFO info);
	/* NE-4100-P & NPort-P Only */
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetRouting(DS_HANDLE dshandle, int *num, PROUTINGTABLE prouting);

/* Serial Port Config */
	/* NE-4100 & NE-4100-CMD Only */
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetSerialPortName(DS_HANDLE dshandle, int port, char name[MAXPORT][PORTNAMELEN]);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetSerialPortName(DS_HANDLE dshandle, int port, char *portname);
IMPORT_EXPORT int SDKCI_FUNC dsc_GetSerialIOCtl(DS_HANDLE dshandle, int port, int mode, PSERPARMITEM info);
IMPORT_EXPORT int SDKCI_FUNC dsc_SetSerialIOCtl(DS_HANDLE dshandle, int port, BYTE baud, BYTE mode, BYTE flowctrl);
IMPORT_EXPORT int SDKCI_FUNC dsc_GetSerialFIFO(DS_HANDLE dshandle, int port, int mode,  LPBYTE info);
IMPORT_EXPORT int SDKCI_FUNC dsc_SetSerialFIFO(DS_HANDLE dshandle, int port, int setting);
IMPORT_EXPORT int SDKCI_FUNC dsc_GetSerialInterface(DS_HANDLE dshandle, int port, int mode, LPBYTE info);
IMPORT_EXPORT int SDKCI_FUNC dsc_SetSerialInterface(DS_HANDLE dshandle, int port, int setting);
IMPORT_EXPORT int SDKCI_FUNC dsc_GetSerialLineStatus(DS_HANDLE dshandle, int port, LPBYTE info);
IMPORT_EXPORT int SDKCI_FUNC dsc_GetSerialDataCount(DS_HANDLE dshandle, int port, PSERDATACNT info);

/* DIO config */
	/* NE all series Only*/
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetMaxDIO(DS_HANDLE dshandle, int* max);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetDIOMode(DS_HANDLE dshandle, int start, int no,int* mode);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetDIOMode(DS_HANDLE dshandle, int start, int no,int* mode);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetDIOState(DS_HANDLE dshandle, int start, int no,int* state);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetDIOState(DS_HANDLE dshandle, int start, int no,int* state);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetDIOPort(DS_HANDLE dshandle, int* port);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetDIOPort(DS_HANDLE dshandle, int* port);


/* Alert Config */
	/* NE-4100 & NE-4100-CMD Only */
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetAlert(DS_HANDLE dshandle, PALERTINFO info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetAlert(DS_HANDLE dshandle, PALERTINFO info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetPortAlert(DS_HANDLE dshandle, int port, PPORTALERTINFO info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetPortAlert(DS_HANDLE dshandle, int port, PPORTALERTINFO info);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetMailAlert(DS_HANDLE dshandle, PMAILINFO mailinfo);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetMailAlert(DS_HANDLE dshandle, PMAILINFO mailinfo);
	IMPORT_EXPORT int SDKCI_FUNC dsc_RetriveMailAcount(DS_HANDLE dshandle, char *username, char *password);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetMailAcount(DS_HANDLE dshandle, char *username, char *password);
	
/* Auto IP Report */
IMPORT_EXPORT int SDKCI_FUNC dsc_GetIPLocation(DS_HANDLE dshandle, int ifid, PIPLOCATIONINFO info);
IMPORT_EXPORT int SDKCI_FUNC dsc_SetIPLocation(DS_HANDLE dshandle, int ifid, PIPLOCATIONINFO info);
IMPORT_EXPORT int SDKCI_FUNC dsc_IPLocationStart(IPLHANDLE *ipl_handle, DWORD local_ip, int port);
IMPORT_EXPORT int SDKCI_FUNC dsc_IPLocationPoll(IPLHANDLE ipl_handle, PIPLOCATION_DATA ipl_data);
IMPORT_EXPORT int SDKCI_FUNC dsc_IPLocationEnd(IPLHANDLE ipl_handle);	

/* Upgrade */
	/* NE-4100 & NE-4100-CMD Only */
	IMPORT_EXPORT int SDKCI_FUNC dsc_Upgrade_WebKernel(DS_HANDLE dshandle, char *filename, PFSINFO fsinfo);
	/* NE-4100-P & NPort-P Only */
	IMPORT_EXPORT int SDKCI_FUNC dsc_UpgradeAP(DS_HANDLE dshandle, char *filename);
	IMPORT_EXPORT int SDKCI_FUNC dsc_UpgradeKernel(DS_HANDLE dshandle, char *filename);
	IMPORT_EXPORT int SDKCI_FUNC dsc_UpgradeAPKernel(DS_HANDLE dshandle, char *filename);
	
/* PPP Config */
	/* Customer Version */
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetPPPConfig(DS_HANDLE dshandle, int port, PPPPCONFIG pconfig);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetPPPConfig(DS_HANDLE dshandle, int port, PPPPCONFIG pconfig);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetPPPAuthTable(DS_HANDLE dshandle, int *retuser, PPPPAUTHTBL pauth);
	IMPORT_EXPORT int SDKCI_FUNC dsc_SetPPPAuthTable(DS_HANDLE dshandle, int user, PPPPAUTHTBL pauth);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetPPPStatus(DS_HANDLE dshandle, int port, PPPPSTATUS pstatus);
	IMPORT_EXPORT int SDKCI_FUNC dsc_GetPPPStatistic(DS_HANDLE dshandle, int port, PPPPSTATISTIC pstatistic);
		
/* Library Config */
IMPORT_EXPORT int SDKCI_FUNC dsc_LibSetProc(DS_HANDLE dshandle, WNDLIBPROC lplibproc, LPVOID lpparam);
IMPORT_EXPORT int SDKCI_FUNC dsc_LibSetTimeout(DS_HANDLE dshandle, int timeout, int retrycnt);
IMPORT_EXPORT int SDKCI_FUNC dsc_LibSetUpgTimeout(DS_HANDLE dshandle, DWORD timeout);
IMPORT_EXPORT void SDKCI_FUNC dsc_SetSearchOpt(int timeout, int retrycnt);

/* 3G */
int SDKCI_FUNC dsc_GetRFC2217Config(DS_HANDLE dshandle, int port, PRFC2217CONFIG conf);
int SDKCI_FUNC dsc_SetRFC2217Config(DS_HANDLE dshandle, int port, PRFC2217CONFIG conf);
int SDKCI_FUNC dsc_SetAsyncIoctl(DS_HANDLE dshandle, int port, PASYNCIOCTL param);

/* WE-2100T only */
int SDKCI_FUNC dsc_GetWlanNetworkType(DS_HANDLE dshandle, int *network_type);
int SDKCI_FUNC dsc_SetWlanNetworkType(DS_HANDLE dshandle, int network_type);
int SDKCI_FUNC dsc_GetWlanProfile(DS_HANDLE dshandle, int network_type, int idx, PWLANPROFILE prof);
int SDKCI_FUNC dsc_SetWlanProfile(DS_HANDLE dshandle, int network_type, int idx, PWLANPROFILE prof);
int SDKCI_FUNC dsc_GetWPAParameter(DS_HANDLE dshandle, int network_type, int idx, PWPAPARAMETER param);
int SDKCI_FUNC dsc_SetWPAParameter(DS_HANDLE dshandle, int network_type, int idx, PWPAPARAMETER param);
int SDKCI_FUNC dsc_UploadConfiguration(DS_HANDLE dshandle, char *filename, int ignore_network);
int SDKCI_FUNC dsc_UploadWPAServerCertificate(DS_HANDLE dshandle, char *filename);
int SDKCI_FUNC dsc_UploadWPAUserCertificate(DS_HANDLE dshandle, char *filename);
int SDKCI_FUNC dsc_UploadWPAUserPrivateKey(DS_HANDLE dshandle, char *filename);
int SDKCI_FUNC dsc_DownloadConfiguration(DS_HANDLE dshandle, char *filename);
int SDKCI_FUNC dsc_DeleteWPAServerCertificate(DS_HANDLE dshandle);
int SDKCI_FUNC dsc_DeleteWPAUserCertificate(DS_HANDLE dshandle);
int SDKCI_FUNC dsc_DeleteWPAUserPrivateKey(DS_HANDLE dshandle);
int SDKCI_FUNC dsc_GetWLANStrengthLEDFunction(DS_HANDLE dshandle, int *enabled);
int SDKCI_FUNC dsc_SetWLANStrengthLEDFunction(DS_HANDLE dshandle, int enabled);
int SDKCI_FUNC dsc_GetNetSelect(DS_HANDLE dshandle, int *select_type);
int SDKCI_FUNC dsc_SetNetSelect(DS_HANDLE dshandle, int select_type);
int SDKCI_FUNC dsc_GetWlanStrength(DS_HANDLE dshandle, int *strength);
int SDKCI_FUNC dsc_GetWlanSpeed(DS_HANDLE dshandle, int *speed);
	
/* Reserve */
IMPORT_EXPORT int SDKCI_FUNC dsc_SetChangeFirmware(DS_HANDLE dshandle, DWORD devip, DWORD netmask, DWORD gateway, DWORD hostip, BYTE flag);
IMPORT_EXPORT int SDKCI_FUNC dsc_GetDebug(DS_HANDLE dshandle, int *setting);
IMPORT_EXPORT int SDKCI_FUNC dsc_SetDebug(DS_HANDLE dshandle, int settings);
IMPORT_EXPORT int SDKCI_FUNC dsc_ClearLog(DS_HANDLE dshandle);
IMPORT_EXPORT int SDKCI_FUNC dsc_RecvLog(DS_HANDLE dshandle, char *buf, DWORD len, DWORD *rlen);
IMPORT_EXPORT int SDKCI_FUNC dsc_Upgrade(DS_HANDLE dshandle, char *filename);
IMPORT_EXPORT int SDKCI_FUNC dsc_UpgradeFile(DS_HANDLE dshandle, char *filename);
int SDKCI_FUNC dsc_GetMAC(DS_HANDLE dshandle, int ifid, char *mac);

#ifdef __cplusplus
}
#endif

#endif
