const argv = require('yargs').argv;
const log4js = require('log4js');
const logger = log4js.getLogger('CreateDb');
const spawn = require('child_process').spawn;

if (!argv.psqlPath) {
    console.log("You must provide psql path.")
    process.exit(1);
}

spawn(argv.psqlPath,
    ['-U', 'mxviewGateway', '-d', 'postgres', '-c', 'CREATE DATABASE gateway ENCODING \'utf8\';'], {env: {PGPASSWORD: process.env.PGPASSWORD}})
    .on('close', (code)=>{
        console.log(code);
    }).stderr.on('data', (err)=>{
        console.error(err.toString());
    });

spawn(argv.psqlPath,
    ['-U', 'mxviewGateway', '-d', 'postgres', '-c', 'CREATE DATABASE gateway_client ENCODING \'utf8\';'], {env: {PGPASSWORD: process.env.PGPASSWORD}})
    .on('close', (code)=>{
        console.log(code);
    }).stderr.on('data', (err)=>{
        console.error(err.toString());
    });

