#!/bin/bash
set -e

DATE=$(date +%Y%m%d%H%M)
HASH=$(git log --pretty=oneline --abbrev-commit -n 1 | cut -d" " -f1)
configs="configs/devices configs/mq_configs configs/opcua_ssl configs/syslog_ssl configs/config.default.json configs/template configs/version.json configs/ouidb.json"
bins="bin/dbtool* bin/healthcheck* bin/MXviewPlatform* bin/startMXsecurity* bin/package_tool* bin/startmq* bin/config_generator* binary/* bin/migrate* bin/sshprompt*"
migrations="migrations"
filename=build_${DATE}_${HASH}.zip
zip -r $filename $bins $configs scripts $migrations
