CREATE TABLE IF NOT EXISTS public.uid_baselines (
    ip VARCHAR(16),
    uid VARCHAR(32),
    last_change timestamptz
);
CREATE TABLE IF NOT EXISTS public.pwd_changes (
    ip VARCHAR(16),
    uid VARCHAR(32),
    password VARCHAR(256),
    pwd_length int default(8),
    last_change timestamptz,
    last_error VARCHAR(256),
	Last_success timestamptz
);

CREATE TABLE IF NOT EXISTS public.pwd_durations (
    setting int DEFAULT 90,
    launch  int DEFAULT 3,
    email1 VARCHAR(64),
    email2 VARCHAR(64),
    pwd_length int DEFAULT 8,
    enable_baseline_check boolean DEFAULT false,
    baseline_check_days int DEFAULT 180,
    last_baseline_check TIMESTAMP WITH TIME ZONE,
    last_default_check TIMESTAMP WITH TIME ZONE
);
insert into public.pwd_durations values(90);

CREATE TABLE IF NOT EXISTS public.temp_pwds (
    ip VARCHAR(16),
    uid VARCHAR(32),
    password VARCHAR(256),
    role VARCHAR(32),
    start_date timestamptz,
    end_date timestamptz,
    started boolean
);

ALTER TABLE settings 
    ADD COLUMN IF NOT EXISTS allow_selfsigned_email_server Boolean DEFAULT TRUE;
ALTER TABLE settings 
    ADD COLUMN IF NOT EXISTS host_name VARCHAR(64);
ALTER TABLE settings 
    ALTER COLUMN system_mail_password TYPE varchar(1024);
ALTER TABLE access_settings
    ALTER COLUMN snmp_encrypt_key TYPE varchar(1024);
ALTER TABLE access_settings
    ALTER COLUMN snmp_password TYPE varchar(1024);
ALTER TABLE device_settings
    ALTER COLUMN password TYPE varchar(1024);