CREATE TABLE IF NOT EXISTS public.unknown_devices (
    mac VARCHAR(16) PRIMARY KEY,
    ip VARCHAR(16),
    connected_ip VARCHAR(16),
    connected_port INT,
    first_seen timestamptz,
    last_seen timestamptz
);
CREATE INDEX IF NOT EXISTS unknown_devices_mac_idx ON public.unknown_devices (mac) TABLESPACE pg_default;

CREATE TABLE IF NOT EXISTS public.to_be_added_devices (
    ip VARCHAR(16)
);

CREATE TABLE IF NOT EXISTS public.ignored_devices (
    mac VARCHAR(16) PRIMARY KEY,
    last_seen timestamptz,
    life_time INT
);
CREATE INDEX IF NOT EXISTS ignored_devices_idx ON public.ignored_devices (mac) TABLESPACE pg_default;

CREATE TABLE IF NOT EXISTS public.rogue_device_global_settings (
    enable boolean DEFAULT false,
    baseline_creation timestamptz
);
insert into public.rogue_device_global_settings values(false);