-- Index: deviceId_and_portId
DROP INDEX IF EXISTS public."traffic_deviceIdAndPortId";
CREATE INDEX IF NOT EXISTS "traffic_deviceIdAndPortId"
    ON public.traffic_records USING btree
    (device_id ASC NULLS LAST, port_index ASC NULLS LAST, record_time ASC NULLS LAST)
    TABLESPACE pg_default;

-- Index: syslog_time
DROP INDEX IF EXISTS public.syslog_time;
CREATE INDEX IF NOT EXISTS syslog_time
    ON public.syslog USING btree
    ("time" DESC NULLS LAST)
    TABLESPACE pg_default;

-- Index: syslog_timeAndIp
DROP INDEX IF EXISTS public."syslog_timeAndIp";
CREATE INDEX IF NOT EXISTS "syslog_timeAndIp"
    ON public.syslog USING btree
    ("time" DESC NULLS LAST, source_ip COLLATE pg_catalog."default" ASC NULLS LAST)
    TABLESPACE pg_default;

-- Index: event_id
DROP INDEX IF EXISTS public.event_id;
CREATE INDEX IF NOT EXISTS event_id
    ON public.events USING btree
    (id DESC NULLS LAST)
    TABLESPACE pg_default;

-- Index: event_ip
DROP INDEX IF EXISTS public.event_ip;
CREATE INDEX IF NOT EXISTS event_ip
    ON public.events USING btree
    (source_ip ASC NULLS LAST)
    TABLESPACE pg_default;

-- Index: event_ipAndTime
DROP INDEX IF EXISTS public."event_ipAndTime";
CREATE INDEX IF NOT EXISTS "event_ipAndTime"
    ON public.events USING btree
    (source_ip ASC NULLS LAST, event_time ASC NULLS LAST)
    TABLESPACE pg_default;

-- Index: event_time
DROP INDEX IF EXISTS public.event_time;
CREATE INDEX IF NOT EXISTS event_time
    ON public.events USING btree
    (event_time DESC NULLS LAST)
    TABLESPACE pg_default;

-- Index: trending_time
DROP INDEX IF EXISTS public.trending_time;
CREATE INDEX IF NOT EXISTS trending_time
    ON public.device_trendings USING btree
    ("time" ASC NULLS LAST)
    TABLESPACE pg_default;

-- Index: trending_idAndTimeAndIndex
DROP INDEX IF EXISTS public."trending_idAndTimeAndIndex";
CREATE INDEX IF NOT EXISTS "trending_idAndTimeAndIndex"
    ON public.device_trendings USING btree
    (property_id ASC NULLS LAST, "time" ASC NULLS LAST, index ASC NULLS LAST)
    TABLESPACE pg_default;

-- Index: wireless_APIdAndTime
DROP INDEX IF EXISTS wireless."wireless_APIdAndTime";
CREATE INDEX IF NOT EXISTS "wireless_APIdAndTime"
    ON wireless.wireless_histories USING btree
    (linked_ap_id ASC NULLS LAST, created_time ASC NULLS LAST)
    TABLESPACE pg_default;

-- Index: wireless_clientIdAndTime
DROP INDEX IF EXISTS wireless."wireless_clientIdAndTime";
CREATE INDEX IF NOT EXISTS "wireless_clientIdAndTime"
    ON wireless.wireless_histories USING btree
    (client_id ASC NULLS LAST, created_time ASC NULLS LAST)
    TABLESPACE pg_default;
	
-- Index: wireless_time
DROP INDEX IF EXISTS wireless.wireless_time;
CREATE INDEX IF NOT EXISTS wireless_time
    ON wireless.wireless_histories USING btree
    (created_time ASC NULLS LAST)
    TABLESPACE pg_default;