CREATE SCHEMA IF NOT EXISTS virtual_topo;

CREATE TABLE IF NOT EXISTS virtual_topo.virtual_nodes (
    id int UNIQUE REFERENCES nodes (id) NOT NULL DEFAULT nextval(pg_get_serial_sequence('nodes', 'id')),
    group_id int REFERENCES groups (id) NOT NULL,
    actual_device_id int REFERENCES devices (id) NOT NULL,
    UNIQUE (group_id, actual_device_id)
);

CREATE TABLE IF NOT EXISTS virtual_topo.virtual_edges (
    id int UNIQUE REFERENCES edges (id) NOT NULL DEFAULT nextval(pg_get_serial_sequence('edges', 'id')),
    group_id int REFERENCES groups (id) NOT NULL,
    lesser_node_id int REFERENCES nodes (id) NOT NULL,
    greater_node_id int REFERENCES nodes (id) NOT NULL,
    actual_link_id int REFERENCES links (id) NOT NULL,
    CHECK (greater_node_id > lesser_node_id),
    UNIQUE (group_id, actual_link_id)
);

-- 節點相關
CREATE OR REPLACE FUNCTION delete_corresponding_node ()
    RETURNS TRIGGER
    AS $$
BEGIN
    DELETE FROM nodes
    WHERE id = OLD.id;
    RETURN OLD;
END;
$$
LANGUAGE plpgsql;

CREATE TRIGGER delete_virtual_node_trigger
    AFTER DELETE ON virtual_topo.virtual_nodes
    FOR EACH ROW
    EXECUTE PROCEDURE delete_corresponding_node ();

CREATE TRIGGER create_virtual_node_trigger
    BEFORE INSERT ON virtual_topo.virtual_nodes
    FOR EACH ROW
    EXECUTE PROCEDURE create_corresponding_node ('virtual');

-- 連線相關
CREATE OR REPLACE FUNCTION delete_corresponding_edge ()
    RETURNS TRIGGER
    AS $$
BEGIN
    DELETE FROM edges
    WHERE id = OLD.id;
    RETURN OLD;
END;
$$
LANGUAGE plpgsql;

CREATE TRIGGER delete_virtual_edge_trigger
    AFTER DELETE ON virtual_topo.virtual_edges
    FOR EACH ROW
    EXECUTE PROCEDURE delete_corresponding_edge ();

CREATE TRIGGER create_virtual_node_trigger
    BEFORE INSERT ON virtual_topo.virtual_edges
    FOR EACH ROW
    EXECUTE PROCEDURE create_corresponding_edge ('virtual');

