CREATE OR REPLACE FUNCTION check_group ()
    RETURNS TRIGGER
    AS $$
BEGIN
    IF NEW.deleted THEN
        IF NEW.id = 0 THEN
            RAISE EXCEPTION 'Attempt to delete root group!';
        END IF;
        IF (
            SELECT
                count(*)
            FROM
                groups
            WHERE
                parent_id = NEW.id AND NOT deleted) > 0 THEN
            RAISE EXCEPTION 'Attempt to delete a group with sub groups!';
        END IF;
        IF (
            SELECT
                count(*)
            FROM
                devices
            WHERE
                group_id = NEW.id AND NOT deleted) > 0 THEN
            RAISE EXCEPTION 'Attempt to delete a group with devices!';
        END IF;
    ELSE
        IF NEW.id <> 0 AND NOT EXISTS (
            SELECT
                1
            FROM
                groups
            WHERE
                id = NEW.parent_id AND NOT deleted) THEN
            RAISE EXCEPTION 'Attempt to add a group to non-existing parent group!';
        END IF;
        IF EXISTS (
            SELECT
                1
            FROM
                groups
            WHERE
                name = NEW.name
                AND NOT deleted
                AND id <> NEW.id) THEN
        RAISE EXCEPTION 'Attempt to add a group with conflicting name!';
    END IF;
END IF;
    RETURN NEW;
END;
$$
LANGUAGE plpgsql;

CREATE TRIGGER update_group_trigger
    BEFORE UPDATE OR INSERT ON groups
    FOR EACH ROW
    EXECUTE PROCEDURE check_group ();

CREATE OR REPLACE FUNCTION check_device ()
    RETURNS TRIGGER
    AS $$
BEGIN
    IF NOT NEW.deleted THEN
        IF (
            SELECT
                count(*)
            FROM
                groups
            WHERE
                id = NEW.group_id AND NOT deleted) <> 1 THEN
            RAISE EXCEPTION 'Attempt to add device to deleted group!';
        END IF;
    END IF;
    RETURN NEW;
END;
$$
LANGUAGE plpgsql;

-- 節點相關
CREATE TRIGGER update_device_trigger
    BEFORE UPDATE OR INSERT ON devices
    FOR EACH ROW
    EXECUTE PROCEDURE check_device ();

CREATE OR REPLACE FUNCTION create_corresponding_node ()
    RETURNS TRIGGER
    AS $$
BEGIN
    INSERT INTO nodes (id, TYPE)
        VALUES (NEW.id, TG_ARGV[0]::node_type);
    RETURN NEW;
END;
$$
LANGUAGE plpgsql;

CREATE TRIGGER create_group_trigger
    BEFORE INSERT ON groups
    FOR EACH ROW
    EXECUTE PROCEDURE create_corresponding_node ('group');

CREATE TRIGGER create_group_trigger
    BEFORE INSERT ON devices
    FOR EACH ROW
    EXECUTE PROCEDURE create_corresponding_node ('device');

-- 連線相關
CREATE OR REPLACE FUNCTION create_corresponding_edge ()
    RETURNS TRIGGER
    AS $$
BEGIN
    INSERT INTO edges (id, TYPE)
        VALUES (NEW.id, TG_ARGV[0]::edge_type);
    RETURN NEW;
END;
$$
LANGUAGE plpgsql;

CREATE TRIGGER create_link_trigger
    BEFORE INSERT ON links
    FOR EACH ROW
    EXECUTE PROCEDURE create_corresponding_edge ('link');

