/*  Copyright (C) MOXA Inc. All rights reserved.

    This software is distributed under the terms of the
    MOXA License.  See the file COPYING-MOXA for details.
*/
/*
    mxgpio_wce.c

    Routines to opearate GPIO ports.

    2009-02-15	CF Lin
		new release
*/
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef CTL_CODE
#undef CTL_CODE
#endif

#define CTL_CODE(DeviceType, Function, Method, Access) ( \
  ((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method) \
)

/* GPIO DeviceIOControl Code */
#define IOCTL_GPIO_GET				CTL_CODE( 0, 101, 0, 0)
#define IOCTL_GPIO_SET				CTL_CODE( 0, 102, 0, 0)
#define IOCTL_GPIO_CLEAR			CTL_CODE( 0, 103, 0, 0)
#define IOCTL_GPIO_CLOCK_ON			CTL_CODE( 0, 104, 0, 0)
#define IOCTL_GPIO_CLOCK_OFF		CTL_CODE( 0, 105, 0, 0)
#define IOCTL_GPIO_BEEP_ON			CTL_CODE( 0, 106, 0, 0)

typedef struct _GPIO 
{
    int pin;
    int val;
} GPIO;

void
mxgpio_close(HANDLE fd)
{
	CloseHandle(fd);
}

/*  open an access to GPIO pins
    Returns:
        a file descriptor of the access
*/
HANDLE
mxgpio_open(void)
{
	HANDLE fd;

	fd = CreateFile ( L"PIO1:", GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL);
	if (fd==INVALID_HANDLE_VALUE)
		return NULL;
	else
		return fd;
}

int 
mxgpio_get_mode(HANDLE fd, int pin)
{
    GPIO pset;

    pset.pin = pin;
    if ( ioctl(fd, IOCTL_PIO_GET_MODE, &pset) != 0 ) 
        return -1;
    else
        return pset.val;
}

int 
mxgpio_get_data(HANDLE fd, int pin)
{
    GPIO pset;

    pset.pin = pin;
    if ( ioctl(fd, IOCTL_PIO_GET_DATA, &pset) != 0 ) 
        return -1;
    else
        return pset.val;
}

int 
mxgpio_set_mode(HANDLE fd, int pin, int val)
{
    GPIO pset;

    pset.pin = pin;
    pset.val = val;
    if ( ioctl(fd, IOCTL_PIO_SET_MODE, &pset) != 0 ) 
        return -1;
    else
        return pset.val;
}

int 
mxgpio_set_data(HANDLE fd, int pin, int val)
{
    GPIO pset;

    pset.pin = pin;
    pset.val = val;
    if ( ioctl(fd, IOCTL_PIO_SET_DATA, &pset) != 0 ) 
        return -1;
    else
        return pset.val;
}
