/*  Copyright (C) MOXA Inc. All rights reserved.

    This software is distributed under the terms of the
    MOXA License.  See the file COPYING-MOXA for details.
*/
/*
    digit_io.c

    Routines to operate the digit I/O in an embedded computer.

*/
#include <windows.h>

#ifdef CTL_CODE
#undef CTL_CODE
#endif

#define CTL_CODE(DeviceType, Function, Method, Access) ( \
  ((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method) \
)

#define IOCTL_SET_DOUT                CTL_CODE( 0, 51, 0, 0)
#define IOCTL_GET_DOUT                CTL_CODE( 0, 52, 0, 0)
#define IOCTL_GET_DIN                   CTL_CODE( 0, 53, 0, 0)
//#define IOCTL_GET_DIN_ALL            CTL_CODE( 0, 54, 0, 0)		
//#define IOCTL_GET_DOUT_ALL         CTL_CODE( 0, 55, 0, 0)

typedef struct _DGTIO 
{
    int	port;
    int	data;
} DGTIO;

void
mxdgio_close(HANDLE hDIO)
{
    CloseHandle	(hDIO);
}

/*	open an access to digit io pins
	Returns:
		a file descriptor of the access
*/
HANDLE
mxdgio_open(void)
{
	HANDLE fd;

	fd = CreateFile ( L"DIO1:", GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL);
	if (fd==INVALID_HANDLE_VALUE)
		return NULL;
	else
		return fd;
}

/*  get the signal state of a digit input 
    Inputs:
	<fd> the access to the device
	<port> port #
    Returns:
	1 or 0 on success, -1 on failure
*/
int
mxdgio_get_input_signal(HANDLE hDIO, int port)
{
    int n;
    DGTIO dio;

	DWORD dwBackSize;

    dio.port = port;
	n = DeviceIoControl(hDIO, IOCTL_GET_DIN,  (void*)&dio, sizeof(DGTIO), (void*)&dio, sizeof(DGTIO), &dwBackSize, NULL);
	return ((n==0)? -1:((dio.data>0)? 1:0));
}

/*	get the signal state of a digit output 
	Inputs:
		<fd> the access to the device
		<port> port #
	Returns:
		1 or 0 on success, -1 on failure
*/
int	
mxdgio_get_output_signal(HANDLE hDIO, int port)
{
    int n;
    DGTIO dio;
	DWORD	dwBackSize;

    dio.port = port;
	n = DeviceIoControl(hDIO, IOCTL_GET_DOUT, (void*)&dio, sizeof(DGTIO), (void*)&dio, sizeof(DGTIO), &dwBackSize, NULL);
	return ((n==0)? -1:((dio.data>0)? 1:0));
}

/*  pass a high signal to a digit output 
    Inputs:
	<fd> the access to the device
	<port> port #
    Returns:
	0 on success, -1 on failure
*/
int	
mxdgio_set_output_signal_high(HANDLE hDIO, int port)
{
    DGTIO		dio;
	DWORD	dwBackSize;
	int				n;

    dio.port = port;
    dio.data = 1;

	n = DeviceIoControl(hDIO, IOCTL_SET_DOUT, (void*)&dio, sizeof(DGTIO), NULL, 0, &dwBackSize, NULL);
	return ((n==0)? -1:0);
}

/*  pass a low signal to a digit output 
    Inputs:
	<fd> the access to the device
	<port> port #
    Returns:
	0 on success, -1 on failure
*/
int	
mxdgio_set_output_signal_low(HANDLE hDIO, int port)
{
    DGTIO		dio;

	DWORD	dwBackSize;
	int				n;

    dio.port = port;
    dio.data = 0;

	n = DeviceIoControl(hDIO, IOCTL_SET_DOUT, (void*)&dio, sizeof(DGTIO), NULL, 0, &dwBackSize, NULL);
	return ((n==0)? -1:0);
}



