/*  Copyright (C) MOXA Inc. All rights reserved.

    This software is distributed under the terms of the
    MOXA License.  See the file COPYING-MOXA for details.
*/
/*
    util.c

    Routines of utility functions

    2008-08-15	CF Lin
		new release
*/
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <time.h>
#include "os-support.h"

/* returns: number of fields found. */
int
split_line (char **temp, int tempcount, char *pkt)
{
    int     i = 0;

    if (!pkt)
	return -1;
    while (isspace (*pkt))
	pkt++;
    while (*pkt && i < tempcount)
    {
	if (*pkt == '"')
	{
	    /* quoted string */
	    pkt++;
	    temp[i++] = pkt;
	    pkt = strchr (pkt, '"');
	    if (!pkt)
	    {
		/* bogus line */
		return -1;
	    }
	    *pkt++ = 0;
	    if (!*pkt)
		break;
	    pkt++;		/* skip the space */
	}
	else
	{
	    temp[i++] = pkt;
	    pkt = strpbrk (pkt, " \t\r\n");
	    if (!pkt)
		break;
	    *pkt++ = 0;
	}
	while (isspace (*pkt))
	    pkt++;
    }
    return i;
}

char*
trim_spaces(char *ptr)
{
    size_t len;

    while (isspace (*ptr))
	ptr++;
    len = strlen (ptr);
    while (len > 0 && isspace (*(ptr + len - 1)))
	len--;
    *(ptr + len) = 0;
    return ptr;
}

void
log_message (const char *fmt, ...)
{
	va_list ap;
	char tbuf[64];
#if !defined (_WIN32_WCE)
	struct tm *lt;
	time_t t = time(0);

	lt = localtime(&t);
	strftime(tbuf, 64, "%Y-%m-%d %H:%M:%S", lt);
#else
	SYSTEMTIME systemTime;

	// get system time
	memset( &systemTime, 0, sizeof(systemTime));
	GetLocalTime(&systemTime);
	sprintf(tbuf, "%d-%02d-%02d %02d:%02d:%02d",
						systemTime.wYear,
						systemTime.wMonth, 
						systemTime.wDay, 
						systemTime.wHour, 
						systemTime.wMinute,
						systemTime.wSecond ); 
#endif
	printf("%s ", tbuf);

	va_start (ap, fmt);
	vprintf (fmt, ap);
	va_end (ap);
	fputc ('\n', stdout);
	fflush (stdout);
}

void*
my_malloc(void *mem, size_t size)
{
	void *px;

	px = malloc(size);
	if (px)	memcpy(px, mem, size);
	return px;
}

